/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.DOMBuilder;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TLiteral;
import com.ebmwebsourcing.easybpel.model.bpel.serviceref.ServiceRefType;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class FromImpl extends AbstractFromOrToImpl<TFrom> implements From {

    public FromImpl(TFrom model, AbstractSchemaElementImpl parent) {
        super(model, parent);
    }

    public final Object resolve(Execution execution) {
        if (hasVariable() && hasPart()) {
            return resolveFromVariablePart(execution);
        } else if (hasPartnerLink()) {
            return resolveFromPartnerLink(execution);
        } else if (hasVariable() && hasProperty()) {
            return resolveFromVariableProperty(execution);
        } else if (hasVariable() && !hasPart()) {
            return resolveFromVariable(execution);
        } else {
            if (hasLiteral()) {
                return resolveFromLiteral(execution);
            } else if (hasExpression()) {
                return resolveFromExpression(execution);
            } else {
                assert false;
            }
        }
        return null;
    }

    private final Object resolveFromLiteral(Execution execution) {
        return getLiteral();
    }

    @Override
    public String getPartnerLink() {
        return getModel().getPartnerLink();
    }

    @Override
    public boolean hasLiteral() {
        return getLiteral() != null;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getLiteral() {
        List<Object> content = getModel().getContent();
        for (Object o : content) {
            if (o instanceof JAXBElement<?>) {
                JAXBElement<TLiteral> jaxbElement = (JAXBElement<TLiteral>) o;
                TLiteral literal = jaxbElement.getValue();
                if ((literal.getContent() == null) || (literal.getContent().isEmpty()))
                    break;
                // might be string or just one Element ;
                // iterate over content looking for an Element, and keep strings
                // in a string buffer in the same time
                Element foundElement = null;
                StringBuffer sb = new StringBuffer();
                for (Object s : literal.getContent()) {

                    if (s instanceof String) {
                        sb.append(String.valueOf(s));
                    } else if (s instanceof org.w3c.dom.Element) {
                        // forget about string buffer and convert DOM element to
                        // JDOM element
                        DOMBuilder domBuilder = new DOMBuilder();
                        foundElement = domBuilder.build((org.w3c.dom.Element) s);
                        return foundElement;
                    } else if (s instanceof JAXBElement<?>) {
                        ServiceRefType serviceRefType = ((JAXBElement<ServiceRefType>) s)
                                .getValue();
                        org.w3c.dom.Element eprElement = (org.w3c.dom.Element) serviceRefType
                                .getAny();
                        DOMBuilder domBuilder = new DOMBuilder();
                        foundElement = new Element(
                                "service-ref",
                                Namespace
                                        .getNamespace("http://docs.oasis-open.org/wsbpel/2.0/serviceref"));
                        foundElement.addContent(domBuilder.build((org.w3c.dom.Element) eprElement).detach());
                        return foundElement;
                    } else {
                        assert false;
                    }
                }
                // wrap String inside a Text node
                return new Text(sb.toString());
            }
        }
        return null;
    }

    @Override
    public Expression getExpression() {
        return super.getExpression(getModel().getContent());
    }

    @Override
    public String getVariable() {
        return getModel().getVariable();
    }

    @Override
    public String getPart() {
        return getModel().getPart();
    }

    @Override
    public QName getProperty() {
        return getModel().getProperty();
    }

    private final Object resolveFromVariable(Execution execution) {
        String variableName = getModel().getVariable();
        return super.resolveFromVariable(execution, variableName);
    }

    protected final Object resolveFromVariableProperty(Execution execution) {
        return super.resolveFromVariableProperty(execution,
                getModel().getVariable());
    }


    private final Object resolveFromVariablePart(Execution execution) {
        String variableName = getModel().getVariable();
        String partName = getModel().getPart();
        return super.resolveFromVariablePart(execution, variableName, partName);
    }

    private final Object resolveFromExpression(Execution execution) {
        return super.resolveFromExpression(execution, getExpression());
    }

    @Override
    public Expression getQuery() {
        return super.getQuery(getModel().getContent());
    }

}
