/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ToImpl extends AbstractFromOrToImpl<TTo> implements To {

    public ToImpl(TTo model, AbstractSchemaElementImpl parent) {
        super(model, parent);
    }

    public final Object resolve(Execution execution) {
        if (hasVariable() && hasPart()) {
            return resolveFromVariablePart(execution);
        } else if (hasPartnerLink()) {
            return resolveFromPartnerLink(execution);
        } else if (hasVariable() && hasProperty()) {
            return resolveFromVariableProperty(execution);
        } else if (hasExpression()) {
            return resolveFromExpression(execution);
        } else if (hasVariable() && !hasPart()) {
            return resolveFromVariable(execution);
        } else {
            assert false;
        }
        return null;
    }

    private final Object resolveFromVariable(Execution execution) {
        String variableName = getModel().getVariable();
        return super.resolveFromVariable(execution, variableName);
    }

    private final Object resolveFromExpression(Execution execution) {
        return super.resolveFromExpression(execution, getExpression());
    }


    private final Object resolveFromVariablePart(Execution execution) {
        String variableName = getModel().getVariable();
        String partName = getModel().getPart();
        return super.resolveFromVariablePart(execution, variableName, partName);
    }

    private final Object resolveFromVariableProperty(Execution execution) {
        return super.resolveFromVariableProperty(execution,
                getModel().getVariable());
    }


    @Override
    public final String getVariable() {
        return getModel().getVariable();
    }

    @Override
    public String getPartnerLink() {
        return getModel().getPartnerLink();
    }

    @Override
    public Expression getQuery() {
        return super.getQuery(getModel().getContent());
    }

    @Override
    public String getPart() {
        return getModel().getPart();
    }

    @Override
    public QName getProperty() {
        return getModel().getProperty();
    }

    @Override
    public QName getTag() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void setTag(QName name) {
        // TODO Auto-generated method stub

    }

    @Override
    public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void addOtherElements(org.w3c.dom.Element elmt) {
        // TODO Auto-generated method stub

    }

    @Override
    public void validate() {
        // TODO Auto-generated method stub
    }

    @Override
    public Expression getExpression() {
        return super.getExpression(getModel().getContent());
    }

}
