/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.AssignValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class AssignValidatorImpl extends ActivityValidatorImpl<Assign> implements AssignValidator {


	public AssignValidatorImpl(final Assign assign) {
		super(assign);
	}

	@Override
	public void validate() {
		// validation
		if((((TAssign)((BPELElementImpl)this.getActivity()).getModel()).getValidate() != null) && ((TAssign)((BPELElementImpl)this.getActivity()).getModel()).getValidate().equals(TBoolean.YES)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In assign " + this.getActivity().getName() + " => [BPEL engine Restriction] Sorry, but the validate attribute at yes is ignored for the moment"));
		}

		if((((TAssign)((BPELElementImpl)this.getActivity()).getModel()).getCopyOrExtensionAssignOperation() == null) || (((TAssign)((BPELElementImpl)this.getActivity()).getModel()).getCopyOrExtensionAssignOperation().size() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In assign " + this.getActivity().getName() + " => the assign MUST have at less one copy")));
		}
	}

}
