/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ForEachValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TForEach;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class ForEachValidatorImpl extends ActivityValidatorImpl<ForEach> implements ForEachValidator {


	public ForEachValidatorImpl(final ForEach forEach) {
		super(forEach);
	}

	@Override
	public void validate() {
		// validation
		if((((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getCompletionCondition() != null) &&
				(((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getCompletionCondition().getBranches() != null)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In ForEach => [BPEL engine restriction] Sorry, but the completionCondition is not supported."));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => [BPEL engine restriction] Sorry, but the completionCondition is not supported.")));
		}

		if((((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getParallel() != null) &&
				((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getParallel().equals(TBoolean.YES)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In ForEach => [BPEL engine restriction] Sorry, but the parrallel attribute at YES is not supported and so, it will be ignored."));
		}


		if(((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getScope() == null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => A forEach MUST have a scope.")));
		}

		
		final String startString = this.getContent(((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getStartCounterValue());
		if((((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getStartCounterValue() == null) || ((startString != null) && (startString.trim().length() == 0))) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => the startCounterValue attribute cannot be null or empty.")));
		}
		final String endString = this.getContent(((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getFinalCounterValue());
		if((((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getFinalCounterValue() == null) || ((endString != null) && (endString.trim().length() == 0))) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => the finalCounterValue attribute cannot be null or empty.")));
		}

		Integer start = null;
		Integer end = null;


		if((((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getStartCounterValue() != null) && ((startString != null) && (startString.trim().length() > 0))) {
			try {
				start = Integer.parseInt(this.getContent(((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getStartCounterValue()));
			} catch (final NumberFormatException e) {
				// do nothing
			}
		}

		if((((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getFinalCounterValue() != null) && ((endString != null) && (endString.trim().length() > 0))) {			
			try {
				end = Integer.parseInt(this.getContent(((TForEach)((BPELElementImpl)this.getActivity()).getModel()).getFinalCounterValue()));
			} catch (final NumberFormatException e) {
				// do nothing
			}
		}

		if((start != null) && (start < 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => the startCounterValue attribute must be superior or egal at 0")));
		}
		if((end != null) && (end < 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => the finalCounterValue attribute must be superior or egal at 0")));
		}

		if((start != null) && (end != null) && (start > end)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In ForEach => the finalCounterValue attribute must be superior or egal at startCounterValue")));
		}


	}


	public String getContent(final TExpression exp) {
		String content = null;
		if((exp != null) && (exp.getContent() != null) && (exp.getContent().size() > 0)) {
			content = exp.getContent().get(0).toString();
		}
		return content;
	}
}
