/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;
import org.petalslink.abslayer.service.api.Property;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.FromValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class FromValidatorImpl implements FromValidator {

	private static Logger log = Logger.getLogger(FromValidatorImpl.class.getName());

	private From from = null;

	public FromValidatorImpl(final From from) {
		this.from = from;
	}

	public void validate() {

		// validation
		log.finest("validate from");

		// verify if exist
		Variable var = null;
		if(((TFrom)((BPELElementImpl)this.from).getModel()).getVariable() != null) {
			var = ScopeImpl.findVariableRecursively(((TFrom)((BPELElementImpl)this.from).getModel()).getVariable(), 
					(BPELElement) ((BPELElementImpl)this.from).getParent());
			if(var == null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => Impossible to find variable corresponding to the name: " + ((TFrom)((BPELElementImpl)this.from).getModel()).getVariable())));
			} 		
		}

		if(((TFrom)((BPELElementImpl)this.from).getModel()).getPart() != null && var != null && 
				!(var instanceof MessageTypeVariable)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => Incorrect. You cannot use \"part\" in \"to\" assignement because the variable \"" + ((TFrom)((BPELElementImpl)this.from).getModel()).getVariable() + "\" is defined as an element or type but not as a messageType")));
		}
		final BPELProcess process = ScopeUtil.getProcess(this.from);
		if(((TFrom)((BPELElementImpl)this.from).getModel()).getPart() != null) {
			if(var != null && var instanceof MessageTypeVariable) {
				TVariable varDef = ((AbstractSchemaElementImpl<TVariable>) var).getModel();

				final Message msg = process.getImports().findMessage(varDef.getMessageType());
				if(msg != null){
					final Part part = msg.getPart(new QName(varDef.getMessageType().getNamespaceURI(), ((TFrom)((BPELElementImpl)this.from).getModel()).getPart()));
					if(part == null) {
						BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => Impossible to find part corresponding to the name: " + ((TFrom)((BPELElementImpl)this.from).getModel()).getPart())));
					}
				}else{
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => Impossible to find message corresponding to the variable: " + varDef.getMessageType())));
				}

			}
		}

		// find partnerLink
		if(((TFrom)((BPELElementImpl)this.from).getModel()).getPartnerLink() != null) {
			final PartnerLink partnerLink = ScopeUtil.findPartnerLinkRecursively(((TFrom)((BPELElementImpl)this.from).getModel()).getPartnerLink(), (BPELElement) ((BPELElementImpl)this.from).getParent());
			if(partnerLink == null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => Impossible to find partnerLink corresponding to the name: " + ((TFrom)((BPELElementImpl)this.from).getModel()).getPartnerLink())));
			}
		}

		if(((TFrom)((BPELElementImpl)this.from).getModel()).getEndpointReference() != null) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.from, "In from => [BPEL engine restriction] Sorry, but the attribute endpoint reference is not used for the moment"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => [BPEL engine restriction] Sorry, but the attribute endpoint reference is not used for the moment")));
		}

        if(((TFrom)((BPELElementImpl)this.from).getModel()).getProperty() != null) {
            final Property prop = process.getImports().getProperty(((TFrom)((BPELElementImpl)this.from).getModel()).getProperty());
            if(prop == null) {
                BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In from => Impossible to find property corresponding to this name " + ((TFrom)((BPELElementImpl)this.from).getModel()).getProperty())));
            }
        }

		if((((TFrom)((BPELElementImpl)this.from).getModel()).getExpressionLanguage() != null) && !((TFrom)((BPELElementImpl)this.from).getModel()).getExpressionLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")
				&& !((TFrom)((BPELElementImpl)this.from).getModel()).getExpressionLanguage().toString().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.from, new BPELException("In expressionLanguage => Unknowned uri: " + ((TFrom)((BPELElementImpl)this.from).getModel()).getExpressionLanguage() + ". Only the uri " + "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0" + " and " + "http://www.w3.org/TR/1999/REC-xpath-19991116"+ " are supported")));
		}
	}


}
