/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.InvokeValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class InvokeValidatorImpl extends ExchangeValidatorImpl<Invoke> implements InvokeValidator {

	private static Logger log = Logger.getLogger(InvokeValidatorImpl.class.getName());

	public InvokeValidatorImpl(final Invoke invoke) {
		super(invoke);
	}

	@Override
	public void validate() {
		super.validate();

		// validation
		log.finest("validate invoke: " + this.getActivity().getName());
			// unsupported element
			if((((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getFromParts() != null) && (((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getFromParts().getFromPart().size() > 0)) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the fromPart activity is not supported by BPEL engine for the moment. Use assign element after this invoke instead"));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the fromPart activity is not supported by BPEL engine for the moment. Use assign element after this invoke instead")));
			}
			if((((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getToParts() != null) && (((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getToParts().getToPart().size() > 0)) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the topart activity is not supported by BPEL engine for the moment. Use assign element before this invoke instead"));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the topart activity is not supported by BPEL engine for the moment. Use assign element before this invoke instead")));
			}
			if(((TInvoke)((BPELElementImpl)this.getActivity()).getModel()).getCompensationHandler() != null) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but compensationHandler is not supported by BPEL engine for the moment."));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but compensationHandler is not supported by BPEL engine for the moment.")));
			}

			// validation if null or empty
			if((this.getActivity().getPartnerLink() == null) || (this.getActivity().getPartnerLink().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the partnerLink cannot be null or empty")));
			}
			if((this.getActivity().getOperation() == null) || (this.getActivity().getOperation().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the operation cannot be null or empty")));
			}
			if((this.getActivity().getInputVariable() == null) || (this.getActivity().getInputVariable().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the input variable cannot be null or empty")));
			}
			if((this.getActivity().getOutputVariable() != null) && (this.getActivity().getInputVariable().trim().length() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => the output variable cannot be empty")));
			}

			// validation if exist

			// find partnerLink
			if((this.getActivity().getPartnerLink() != null) && (this.getActivity().getPartnerLink().trim().length() > 0)) {
				final PartnerLink partnerLink = ScopeUtil.findPartnerLinkRecursively(this.getActivity().getPartnerLink(), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(partnerLink == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find partnerLink corresponding to the name: " + this.getActivity().getPartnerLink())));
				}

				// find operation
				if((this.getActivity().getOperation() != null) && (this.getActivity().getOperation().trim().length() > 0)) {
					if(partnerLink != null) {
						final BPELProcess process = ScopeUtil.getProcess((this.getActivity()));

						final List<Interface> itfsToVerify = new ArrayList<Interface>();
						if(this.getActivity().getInterface() != null) {
							final Interface itf = process.getImports().findInterface(this.getActivity().getInterface());
							if(itf != null) {
								itfsToVerify.add(itf);
							}
						} else {
							final PartnerLinkType plt = process.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
							if(plt == null) {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In receive " + this.getActivity().getName() + " => Impossible to find partnerLink corresponding to the name: " + partnerLink.getPartnerLinkType())));
							}
							if(plt != null) {
								if(((partnerLink.getMyRole() == null) || (partnerLink.getMyRole().trim().length() == 0))&&
										((partnerLink.getPartnerRole() == null) || (partnerLink.getPartnerRole().trim().length() == 0))) {
									// get all role of partnerLink type
									for(final Role r: plt.getRoles()) {
									    Interface itf = process.getImports().findInterface(r.getInterfaceQName());
										if(itf == null) {
											BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the portType corresponding to role: " + r.getName())));
										}
										if(itf != null) {
											itfsToVerify.add(itf);
										}
									}
								} else {
									if((partnerLink.getMyRole() != null) && (partnerLink.getMyRole().trim().length() > 0)) {
										for(final Role r: plt.getRoles()) {
	                                        Interface itf = process.getImports().findInterface(r.getInterfaceQName());
											if(r.getName().equals(partnerLink.getMyRole())) {
												itfsToVerify.add(itf);
												break;
											}
										}
									} 
									if((partnerLink.getPartnerRole() != null) && (partnerLink.getPartnerRole().trim().length() > 0)) {
										for(final Role r: plt.getRoles()) {
	                                        Interface itf = process.getImports().findInterface(r.getInterfaceQName());
											if(itf == null) {
												BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the portType corresponding to role: " + r.getName())));
											}
											if(r.getName().equals(partnerLink.getPartnerRole()) && itf != null) {
												itfsToVerify.add(itf);
												break;
											}
										}
									}
								}
							}
						}
						final List<Operation> ops = new ArrayList<Operation>();
						if(itfsToVerify.size() == 0) {
							if(this.getActivity().getInterface() != null) {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the portType: " + this.getActivity().getInterface())));
							} else {
								BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find portType. You must add portType attribute in invoke or add a role to the partnerLink of invoke")));
							}
						}

						for(final Interface itf: itfsToVerify) {
							final Operation op = itf.getOperation(new QName(itf.getQName().getNamespaceURI(), this.getActivity().getOperation()));
							if(op != null) {
								ops.add(op);
							}
						}

						if(ops.size() == 0) {
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find in wsdl descriptions the operation: " + this.getActivity().getOperation())));
						} else if(ops.size() > 1) {
							String itfString = null;
							for(final Operation op: ops) {
								if(itfString == null) {
									itfString = op.getParentInterface().getQName().toString();
								} else {
									itfString = itfString + ", " + op.getParentInterface().getQName().toString();
								}
							}
							BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Several interfaces match with the operation " + this.getActivity().getOperation() + ": " + itfString + ". " +  "You must add portType attribute in invoke or add a role to the partnerLink of invoke")));
						}

					}



				}

			}

			// find variable
			if((this.getActivity().getInputVariable() != null) && (this.getActivity().getInputVariable().trim().length() > 0)) {
				final Variable var = ScopeImpl.findVariableRecursively(this.getActivity().getInputVariable(), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(var == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find input variable corresponding to the name: " + this.getActivity().getInputVariable())));
				}
			}
			if((this.getActivity().getOutputVariable() != null) && (this.getActivity().getOutputVariable().trim().length() > 0)) {
				final Variable var = ScopeImpl.findVariableRecursively(this.getActivity().getOutputVariable(), (BPELElement) ((BPELElementImpl)this.getActivity()).getParent());
				if(var == null) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("In invoke " + this.getActivity().getName() + " => Impossible to find output variable corresponding to the name: " + this.getActivity().getOutputVariable())));
				}
			}
	}

}
