/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ProcessValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELInfoImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class ProcessValidatorImpl implements ProcessValidator {

	private BPELProcess process = null;

	public ProcessValidatorImpl(final BPELProcess process) {
		this.process = process;
	}

	public void validate() {
		// validation

		// validation if null or empty
		if((this.process.getName() == null) || (this.process.getName().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => the name of process cannot be null or empty")));
		}
		if((this.process.getTargetNamespace() == null) || (this.process.getTargetNamespace().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => the targetNamespace of process cannot be null or empty")));
		}

		final TProcess tprocess = ((TProcess)((BPELElementImpl)this.process).getModel());
		// restriction: ignored 
		if(tprocess.getSuppressJoinFailure() != null) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the suppressJoinFailure attribute is ignored for the moment"));
		}
		if(tprocess.getExitOnStandardFault() != null) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the exitOnStandardFault attribute is ignored for the moment"));
		}

		// validation on partnerLink
		if((tprocess.getPartnerLinks() == null) || (tprocess.getPartnerLinks().getPartnerLink() == null) || (tprocess.getPartnerLinks().getPartnerLink().size() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => A process MUST have at less one partnerLink")));
		}

		// validation on variable
		if((tprocess.getVariables() == null) || (tprocess.getVariables().getVariable() == null) || (tprocess.getVariables().getVariable().size() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => A process MUST have at less one variable")));
		}

		// restriction: error 
		if((tprocess.getPartnerLinks() != null) && (tprocess.getPartnerLinks().getPartnerLink() != null) && (tprocess.getPartnerLinks().getPartnerLink().size() > 0)) {
			boolean myRole = false;
			for(final TPartnerLink pl: tprocess.getPartnerLinks().getPartnerLink()) {
				if((pl.getMyRole() != null) && (pl.getMyRole().trim().length() > 0)) {
					myRole = true;
				}
			}
			if(!myRole) {
				BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.process, "In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute"));
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] A process MUST have at less one partnerLink with a myRole attribute")));
			}
		}
		if((tprocess.getMessageExchanges() != null) && (tprocess.getMessageExchanges().getMessageExchange().size() > 0)) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the messageExchanges are not supported for the moment"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
		}


		if( (tprocess.getEventHandlers() != null) &&
				((tprocess.getEventHandlers().getOnEvent().size() > 0) ||
						(tprocess.getEventHandlers().getOnAlarm().size() > 0))) {
			BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.process, "In process => [BPEL engine restriction] Sorry, but the eventHandler are not supported for the moment"));
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.process, new BPELException("In process => [BPEL engine restriction] Sorry, but the extensions are not supported for the moment")));
		}



	}

}
