/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.List;

import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Message;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.VariableValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

public class VariableValidatorImpl implements VariableValidator {

	private Variable var = null;

	public VariableValidatorImpl(final Variable var) {
		this.var = var;
	}

	public void validate() {
		// validation

		// validation if null or empty
		if((this.var.getName() == null) || (this.var.getName().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Variable cannot be null or empty")));
		}
		
		TVariable varDef = ((AbstractSchemaElementImpl<TVariable>) var).getModel();

		// validation on content
		if(((varDef.getMessageType() == null) || (varDef.getMessageType().getLocalPart().trim().length() == 0)) &&
				((varDef.getElement() == null) || (varDef.getElement().getLocalPart().trim().length() == 0)) &&
				((varDef.getType() == null) || (varDef.getType().getLocalPart().trim().length() == 0))) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => You must define the variable. Please, Set this type using messageType, element, or type attribute")));
		}
		
		
		final BPELProcess process = ScopeUtil.getProcess(this.var);
		
		// find if message exist
		if(varDef.getMessageType() != null) {
			final Message msg = process.getImports().findMessage(varDef.getMessageType());
			if(msg == null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Impossible to find message \"" + varDef.getMessageType() +"\" of variable " + this.var.getName())));
			}
		}
		
		// find if element exist
		if(varDef.getElement() != null) {
			final List<Element> elmts = process.getImports().findElementsInAllSchema(varDef.getElement());
			if((elmts == null)||(elmts.size() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Impossible to find element \"" + varDef.getElement() +"\" of variable " + this.var.getName())));
			}
		}
		
		// find if type exist
		if(varDef.getType() != null) {
			final Type type = SchemaFactory.getDefaultSchema().getType(varDef.getType());
			if(type == null) {
				final List<com.ebmwebsourcing.easyschema10.api.type.Type> types = 
				    process.getImports().findTypesInAllSchema(varDef.getType()); 
				if(types.size() == 0) {
					BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Impossible to find type \"" + varDef.getElement() +"\" of variable " + this.var.getName())));
				}
			}
		}
	}

}
