/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.extension;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extension;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtension;

public class ExtensionImpl extends BPELElementImpl<TExtension> implements Extension {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;



	public ExtensionImpl(final TExtension model, final BPELElement parent) {
		super(Constants._Extension_QNAME, model, parent);
	}



	public Boolean getMustUnderstand() {
		Boolean res = null;
		if(this.model.getMustUnderstand() != null) {
			if(this.model.getMustUnderstand().equals(TBoolean.YES) ) {
				res = true;
			} else {
				res = false;
			}
		}
		return res;
	}



	public String getNameSpace() {
		return this.model.getNamespace();
	}

}
