/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.extension;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extension;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extensions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtension;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensions;

public class ExtensionsImpl extends BPELElementImpl<TExtensions> implements Extensions {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private List<Extension> extensions = new ArrayList<Extension>();
	

	public ExtensionsImpl(final TExtensions model, final BPELElement parent) {
		super(Constants._Extensions_QNAME, model, parent);
		
		// get all extensions
		if(this.model.getExtension() != null) {
			for(TExtension extension: this.model.getExtension()) {
				this.extensions.add(new ExtensionImpl(extension, this));
			}
		}
	}



	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}



	public List<Extension> getExtensions() {
		return this.extensions;
	}



	public Extension findExtension(String namespace) {
		Extension res = null;
		for(Extension ex: this.extensions) {
			if(ex.getNameSpace().equals(namespace)) {
				res = ex;
				break;
			}
		}
		return res;
	}

	

}
