/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.fault;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCatch;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFaultHandlers;

public class FaultHandlersImpl extends BPELElementImpl<TFaultHandlers> implements FaultHandlers {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private final List<Catch> catchs = new ArrayList<Catch>();
	
	private CatchAll catchAll = null;

	public FaultHandlersImpl(final TFaultHandlers model, final BPELElementImpl parent) {
		super(Constants._FaultHandlers_QNAME, model, parent);
		
		// get all catch
		if(this.model.getCatch() != null) {
			for(final TCatch catch_: this.model.getCatch()) {
				this.catchs.add(new CatchImpl(catch_, this));
			}
		}
		
		// get catchAll
		if(this.model.getCatchAll() != null) {
			this.catchAll = new CatchAllImpl(this.model.getCatchAll(), this);
		}
	}

	public CatchAll getCatchAll() {
		return this.catchAll;
	}

	public List<Catch> getCatchs() {
		return this.catchs;
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}
	

}
