/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.variable;

import java.util.List;

import org.jdom.Element;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.variable.ElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

public class ElementVariableImpl extends AbstractVariableImpl implements ElementVariable {

    /**
	 * 
	 */
    private static final long serialVersionUID = -96063040861625808L;

    @SuppressWarnings("rawtypes")
    public ElementVariableImpl(TVariable model, SchemaElement parent) {
        super(model, (AbstractSchemaElementImpl) parent);
    }

    @Override
    public String getName() {
        return getModel().getName();
    }

    @Override
    public final Element getValue(Execution execution) {
        return (Element) super.getValue(execution);
    }

    @Override
    protected final Element guessInitValue() {
        BPELProcessImpl bpelProcess = (BPELProcessImpl) getTopParent();
        final List<com.ebmwebsourcing.easyschema10.api.element.Element> elmts = bpelProcess
                .getImports().findElementsInAllSchema(getModel().getElement());
        assert !elmts.isEmpty();
        final com.ebmwebsourcing.easyschema10.api.element.Element elmt = elmts.get(0);

        Schema parentSchema = SchemaHelper.findParentSchema(elmt);
        final Element element = XSD2XML.newInstance().generateElement(elmt, elmt, null,
                parentSchema.getElementFormDefault(), 1, false, true);

        return element;
    }

}
