/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.variable;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

import com.ebmwebsourcing.easybpel.model.bpel.api.variable.MessageTypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.type.Form;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;

public class MessageTypeVariableImpl extends AbstractVariableImpl implements MessageTypeVariable {

    /**
	 * 
	 */
    private static final long serialVersionUID = -8399765339449516595L;

    @SuppressWarnings("rawtypes")
    public MessageTypeVariableImpl(TVariable model, SchemaElement parent) {
        super(model, (AbstractSchemaElementImpl) parent);
    }

    @Override
    public String getName() {
        return getModel().getName();
    }

    @Override
    public final Element getValue(Execution execution) {
        return (Element) super.getValue(execution);
    }

    protected final Element setValueHook(Execution execution, Object partsElements) {
        assert partsElements != null;

        if (partsElements instanceof Element) {
            // only used when initializing a whole message type variable with a
            // litteral!
            // this should be forbidden since it creates a dependency between
            // abstract BPEL process
            // description, and its binding. this does not seem to be
            // explicitely forbidden by spec,
            // but we should raise a warning at validation time.
            List<Element> childrenElements = ((Element) partsElements).getChildren();
            // forget about root element which is an "internal representation"
            // thing.
            partsElements = childrenElements.toArray(new Element[childrenElements.size()]);
        }

        assert partsElements instanceof Element[];
        // create an arbitrarily named root enclosing element
        // (see BPEL spec section 8.1 ; step 2a).
        final Element messageElement = new Element(getModel().getMessageType().getLocalPart(),
                getModel().getMessageType().getNamespaceURI());
        new Document(messageElement);
        for (Element partElement : (Element[]) partsElements) {
            messageElement.addContent(((Element) partElement.clone()).detach());
        }
        return messageElement;
    }

    @Override
    protected Element[] guessInitValue() {
        List<Element> partsElements = new ArrayList<Element>();
        // the following code is out of BPEL spec : if no from-spec is provided
        // variable should be left uninitialized (null);
        BPELProcessImpl bpelProcess = (BPELProcessImpl) getTopParent();
        final Message msg = bpelProcess.getImports().findMessage(getModel().getMessageType());
        assert msg != null;

        for (final Part part : msg.getParts()) {
            // create part
            if (part.getElement() != null) {
                final com.ebmwebsourcing.easyschema10.api.element.Element elmt = part.getElement();
                final Element content = XSD2XML.newInstance()
                        .generateElement(elmt, part.getDescription().getModel(), null,
                                SchemaHelper.findParentSchema(elmt).getElementFormDefault(), 1,
                                false, true);
                partsElements.add((Element) content.detach());
            } else if (part.getType() != null) {
                final com.ebmwebsourcing.easyschema10.api.element.Element elmt = part
                        .createElement();
                elmt.setName(part.getQName().getLocalPart());
                elmt.setType(part.getType());
                final Element content = XSD2XML.newInstance().generateElement(elmt,
                        part.getDescription().getModel(), null, Form.QUALIFIED, 1, false, true);
                content.setNamespace(null);
                partsElements.add((Element) content.detach());
            }
        }
        return partsElements.toArray(new Element[partsElements.size()]);
    }

}
