/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.variable;

import java.util.List;

import org.jdom.Element;
import org.jdom.Text;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.TypeVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.type.Form;

public class TypeVariableImpl extends AbstractVariableImpl implements TypeVariable {

    private static final long serialVersionUID = -179950753833069238L;

    @SuppressWarnings("rawtypes")
    public TypeVariableImpl(TVariable model, SchemaElement parent) {
        super(model, (AbstractSchemaElementImpl) parent);
    }

    @Override
    public String getName() {
        return getModel().getName();
    }

    @Override
    protected Object guessInitValue() {
        // the following code is out of BPEL spec : if no from-spec is provided
        // variable should be left uninitialized (null);
        BPELProcessImpl bpelProcess = (BPELProcessImpl) getTopParent();
        Descriptions desc = bpelProcess.getImports();

        com.ebmwebsourcing.easyschema10.api.type.Type type = SchemaHelper.findTypeByQName(
                SchemaOfSchemas.getSchema(), getModel().getType());
        if (type == null) {
            final List<com.ebmwebsourcing.easyschema10.api.type.Type> types = desc
                    .findTypesInAllSchema(getModel().getType());

            if (types.size() == 0) {
                throw new BPELException("Impossible to find type \"" + getModel().getType()
                        + "\" in all schemas");
            }
            type = types.get(0);
        }

        if (type == null) {
            throw new BPELException("Impossible to find type \"" + getModel().getType()
                    + "\" in all schemas");
        }

        
        
        XmlObjectFactory factory = type.getXmlContext().getXmlObjectFactory();
        final com.ebmwebsourcing.easyschema10.api.element.Schema schema = factory
                .create(com.ebmwebsourcing.easyschema10.api.element.Schema.class);
        schema.setTargetNamespace(desc.getProcessNamespace());
        schema.setElementFormDefault(Form.QUALIFIED);
        schema.setAttributeFormDefault(Form.QUALIFIED);

        final com.ebmwebsourcing.easyschema10.api.element.Element elmt = factory
                .create(com.ebmwebsourcing.easyschema10.api.element.Element.class);

        elmt.setName(getName());
        elmt.setType(type.inferQName());
        schema.addElement(elmt);
        // TODO : this is should be done statically at compile time!!
        // otherwise this generates
        // unnecessary synchronization issues on addSchema and
        // getSchemas...
        desc.addSchema(schema);

        final Element jDomElmt = XSD2XML.newInstance().generateElement(elmt,
                SchemaHelper.findParentSchema(type), null, schema.getElementFormDefault(), 1,
                false, true);
        
        if (SchemaHelper.isTypeDerivedFromAnySimpleType(type, type.inferQName())) {
            assert jDomElmt.getContent().size() == 1;
            assert jDomElmt.getContent().get(0) instanceof Text;
            return jDomElmt.getContent().get(0);
        } else {
            return jDomElmt;
        }
    }
    


}
