/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.petalslink.abslayer.WSDLVersionConstants;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.XMLConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;


/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ImportImpl extends BPELElementImpl<TImport> implements Import {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	public Description description = null;

	public com.ebmwebsourcing.easyschema10.api.element.Schema schema = null;

	//TODO Change URI parameter to URL parameter ?
	public ImportImpl(final TImport model, final BPELElement parent) {
		super(Constants._Import_QNAME, model, parent);

		//TODO Check this code (both the same code) unnecessary ?
		//TODO Manage all protocols (not only local) for the baseURI parameter
		try {
			final BPELProcess process = ScopeUtil.getProcess(this);
			final URI baseUri = process.getDocumentBaseURI();

			if(this.getImportType() != null) {
				if(this.getImportType().toString().equals(WSDLVersionConstants.WSDL11.value().toString())) {
					if(this.getLocation() != null) {
						URL location = null;
						if(baseUri.isAbsolute()) {
							String path = baseUri.toString().substring(0, baseUri.toString().lastIndexOf("/") + 1) + this.getLocation().toString();
							final URI locationUri = URI.create(path);
							location = locationUri.toURL();
						} else {
							location = (new File(baseUri.normalize().toString()+this.getLocation())).toURI().toURL();
						}
						this.description = Descriptions.readDescription11(location);
					}
				} else if(this.getImportType().toString().equals(WSDLVersionConstants.WSDL20.value().toString())) {
					if(this.getLocation() != null) {
						URL location = null;
						if(baseUri.isAbsolute()) {
							String path = baseUri.toString().substring(0, baseUri.toString().lastIndexOf("/") + 1) + this.getLocation().toString();
							final URI locationUri = URI.create(path);
							location = locationUri.toURL();
						} else {
							location = (new File(baseUri.normalize().toString()+this.getLocation())).toURI().toURL();
						}
						this.description = Descriptions.readDescription20(location);
					}
				} else if(this.getImportType().toString().equals(XMLConstants.W3C_XML_SCHEMA_NS_URI)) {
					if(this.getLocation() != null) {
						URL location = null;
						if(baseUri.isAbsolute()) {
							String path = baseUri.toString().substring(0, baseUri.toString().lastIndexOf("/") + 1) + this.getLocation().toString();
							final URI locationUri = URI.create(path);
							location = locationUri.toURL();
						} else {
							location = (new File(baseUri.normalize().toString()+this.getLocation())).toURI().toURL();
						}
						this.schema = Descriptions.readSchema(location);
					}
				} 
			}
		} catch (final SchemaException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		} catch (final MalformedURLException e){
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		} catch (final com.ebmwebsourcing.easybox.api.XmlObjectReadException e){
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("Error to import file: " + this.getLocation() + " => " + e.getMessage(),e)));
		}
	}

	public Description getDescription() {
		return this.description;
	}

	public URI getImportType()  {
		URI res = null;
		if(this.model.getImportType() != null) {
			res = URI.create(this.model.getImportType());
		} 
		return res;
	}

	public void setImportType(URI uri){
		this.model.setImportType(uri.toString());
	}


	public URI getLocation() {
		URI res = null;
		if(this.model.getLocation() != null) {
			res = URI.create(this.model.getLocation());
		}
		return res;
	}
	
	public void setLocation(URI uri){
		this.model.setLocation(uri.toString());
		}

	public URI getNamespace() {
		URI res = null;
		if(this.model.getNamespace() != null) {
			res = URI.create(this.model.getNamespace());
		} 		
		return res;
	}

	public void setDescription(Description description) {
		this.description = description;
	}

	public void setSchema2(com.ebmwebsourcing.easyschema10.api.element.Schema schema) {
		this.schema = schema;
	}

	public void setNamespace(URI uri){
		this.model.setNamespace(uri.toString());
	}
	
	public com.ebmwebsourcing.easyschema10.api.element.Schema getSchema2() {
		return this.schema;
		
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}

}

