/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class BPELAssignmentExpressionImpl implements AssignementExpression {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(BPELAssignmentExpressionImpl.class.getName());

	private final Copy copy;
	
	private Object left;
	
	private Object right;
	
	private BPELProcess bpelDefinition;
	
	public BPELAssignmentExpressionImpl(final Copy copy, final BPELProcess definition) {
		this.copy = copy;
		this.bpelDefinition = definition;
		this.left = this.copy.getTo();
		this.right = this.copy.getFrom();
	}

	public Object getLeft() {
		return this.left;
	}

	public Object getRight() {
		return this.right;
	}

	public BPELProcess getBpeldefinition() {
		return this.bpelDefinition;
	}

	public void setBpeldefinition(final BPELProcess bpeldefinition) {
		this.bpelDefinition = bpeldefinition;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	
}
