/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.function;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uri.URIHelper;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jdom.Element;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

public class DoXslTransformFunction
implements Function {
    private final URI baseURI;

    public DoXslTransformFunction(URI baseURI) {
        this.baseURI = baseURI;
    }

    public Object call(Context context, List args) throws FunctionCallException {
        Element element;
        assert (args.size() >= 2);
        String relativeUriString = (String)args.get(0);
        Element nodeSet = (Element)args.get(1);
        JDOMSource source = new JDOMSource(nodeSet);
        InputStream styleSheetStream = null;
        try {
            URI styleSheetUri = URIHelper.resolve((URI)this.baseURI, (String)relativeUriString);
            styleSheetStream = styleSheetUri.toURL().openStream();
            StreamSource styleSheet = new StreamSource(styleSheetStream);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(styleSheet);
            if (args.size() > 2) {
                assert (args.size() % 2 == 0);
                int i = 2;
                while (i < args.size()) {
                    Object value = args.get(i + 1);
                    if (value instanceof Element) {
                        value = ((Element)value).getText();
                    }
                    transformer.setParameter(String.valueOf(args.get(i)), value);
                    i += 2;
                }
            }
            JDOMResult result = new JDOMResult();
            transformer.transform((Source)source, (Result)result);
            element = result.getDocument().getRootElement();
            Object var13_16 = null;
        }
        catch (Exception e) {
            try {
                throw new UncheckedException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                IOHelper.close(styleSheetStream);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)styleSheetStream);
        return element;
    }
}

