
package com.ebmwebsourcing.easycommons.time;

import java.util.Calendar;
import java.util.TimeZone;

/**
 * 
 * @author "Mathieu CARROLLE - mathieu.carrolle@petalslink.com"
 * 
 */
public class SimulatedTime implements Time {

    // init utcTime when class is loaded
    long utcTime = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();

    boolean isPaused = false;

    @Override
    public long getUtcTime() {
        if (!isPaused) {
            this.utcTime = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        }
        return this.utcTime;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void resume() {
        this.isPaused = false;
    }
}
