/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.io.ByteChannelDumpHelper;
import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ByteChannelDumpHelperTest {
    private static final int[] TEST_INPUT_DATA_SIZES = new int[]{1, 2, 3, 8, 16, 32, 47};
    private static final int[] TEST_BYTE_BUFFER_SIZES = new int[]{1, 2, 4, 64, 65};
    private static File dumpDirectory;

    @BeforeClass
    public static final void beforeClass() throws IOException {
        dumpDirectory = FileSystemHelper.createTempDir();
    }

    @AfterClass
    public static final void afterClass() throws IOException {
        FileSystemHelper.forceDelete((File)dumpDirectory);
    }

    @Test
    public void testCreateDumpFileChannelWithNonEmptyExistingFile() throws Exception {
        File dumpFile = this.createExistingTempFile();
        FileOutputStream fos = new FileOutputStream(dumpFile);
        fos.write(1);
        fos.close();
        FileChannel fileChannel = ByteChannelDumpHelper.createDumpFileChannel((File)dumpFile);
        this.checkFileExistsAndEmpty(dumpFile);
        this.checkFileChannelIsReadyAndEmpty(fileChannel);
    }

    @Test
    public void testCreateDumpFileChannelWithNonExistingDumpFile() throws Exception {
        File dumpFile = this.createNonExistingTempFile();
        FileChannel fileChannel = ByteChannelDumpHelper.createDumpFileChannel((File)dumpFile);
        this.checkFileExistsAndEmpty(dumpFile);
        this.checkFileChannelIsReadyAndEmpty(fileChannel);
    }

    @Test
    public void testCreateDumpFileChannelWithNonExistingDumpFileDirectory() throws Exception {
        File dumpFile = this.createTempFileInANonExistingDirectory();
        FileChannel fileChannel = ByteChannelDumpHelper.createDumpFileChannel((File)dumpFile);
        this.checkFileExistsAndEmpty(dumpFile);
        this.checkFileChannelIsReadyAndEmpty(fileChannel);
    }

    private final File createExistingTempFile() throws IOException {
        dumpDirectory.mkdirs();
        File dumpFile = File.createTempFile("dump", null, dumpDirectory);
        return dumpFile;
    }

    private final File createNonExistingTempFile() throws IOException {
        File dumpFile = this.createExistingTempFile();
        FileSystemHelper.forceDelete((File)dumpFile);
        return dumpFile;
    }

    private final File createTempFileInANonExistingDirectory() throws IOException {
        File dumpFile = this.createExistingTempFile();
        FileSystemHelper.forceDelete((File)dumpDirectory);
        return dumpFile;
    }

    private void checkFileChannelIsReadyAndEmpty(FileChannel fileChannel) throws IOException {
        Assert.assertTrue((boolean)fileChannel.isOpen());
        Assert.assertEquals((long)0L, (long)fileChannel.size());
        Assert.assertEquals((long)0L, (long)fileChannel.position());
    }

    private void checkFileExistsAndEmpty(File file) {
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((file.length() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testReadBufferByBufferFromVariousInputsWithVariousBufferSizes() throws Exception {
        this.testProcessBufferByBufferFromVariousInputsWithVariousBufferSizes(new BufferByBufferReadTesterBuilder());
    }

    @Test
    public void testWriteBufferByBufferFromVariousInputsWithVariousBufferSizes() throws Exception {
        this.testProcessBufferByBufferFromVariousInputsWithVariousBufferSizes(new BufferByBufferWriteTesterBuilder());
    }

    private void testProcessBufferByBufferFromVariousInputsWithVariousBufferSizes(AbstractMethodTesterBuilder testerBuilder) throws Exception {
        for (int i : TEST_INPUT_DATA_SIZES) {
            testerBuilder.setTestInputData(this.generateTestInputData(i));
            for (int j : TEST_BYTE_BUFFER_SIZES) {
                testerBuilder.setByteBuffer(new byte[j]);
                testerBuilder.setDumpFile(this.createExistingTempFile());
                Integer[] arr$ = this.generateTestOffsets(j);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int testOffset = arr$[i$];
                    testerBuilder.setOffset(testOffset);
                    Integer[] arr$2 = this.generateTestLens(j, testOffset);
                    int len$2 = arr$2.length;
                    for (int i$2 = 0; i$2 < len$2; ++i$2) {
                        int testLen = arr$2[i$2];
                        testerBuilder.setLen(testLen);
                        AbstractMethodTester tester = testerBuilder.build();
                        tester.testCallUntilEndOfStream();
                    }
                }
            }
        }
    }

    @Test
    public void testReadBufferByBufferFromEmptyInput() throws Exception {
        BufferByBufferReadTesterBuilder testerBuilder = new BufferByBufferReadTesterBuilder();
        testerBuilder.setByteBuffer(new byte[4]);
        testerBuilder.setOffset(1);
        testerBuilder.setLen(1);
        this.testReadFromEmptyInput(testerBuilder);
    }

    private void testReadFromEmptyInput(AbstractMethodTesterBuilder testerBuilder) throws Exception {
        testerBuilder.setDumpFile(this.createExistingTempFile());
        testerBuilder.setTestInputData(new byte[0]);
        AbstractMethodTester tester = testerBuilder.build();
        Assert.assertEquals((long)-1L, (long)tester.callMethodOnce());
    }

    @Test(expected=ClosedChannelException.class)
    public void testReadBufferByBufferFromClosedInput() throws Exception {
        BufferByBufferReadTesterBuilder testerBuilder = new BufferByBufferReadTesterBuilder();
        this.testProcessOnClosedStream(testerBuilder);
    }

    @Test(expected=ClosedChannelException.class)
    public void testWriteBufferByBufferOnClosedOutput() throws Exception {
        BufferByBufferWriteTesterBuilder testerBuilder = new BufferByBufferWriteTesterBuilder();
        this.testProcessOnClosedStream(testerBuilder);
    }

    private void testProcessOnClosedStream(AbstractMethodTesterBuilder testerBuilder) throws Exception {
        testerBuilder.setByteBuffer(new byte[1]);
        testerBuilder.setOffset(0);
        testerBuilder.setLen(1);
        testerBuilder.setDumpFile(this.createExistingTempFile());
        testerBuilder.setTestInputData(new byte[]{1, 2});
        AbstractMethodTester tester = testerBuilder.build();
        tester.getChannelToDump().close();
        tester.callMethodOnce();
    }

    private byte[] generateTestInputData(int length) {
        byte[] testInputData = new byte[length];
        for (int i = 0; i < testInputData.length; ++i) {
            testInputData[i] = (byte)i;
        }
        return testInputData;
    }

    private final Integer[] generateTestLens(int j, int testOffset) {
        HashSet<Integer> testLens = new HashSet<Integer>();
        for (int testLen : new int[]{j - testOffset, (j - testOffset) / 2, 1}) {
            if (testLen == 0) continue;
            testLens.add(testLen);
        }
        return testLens.toArray(new Integer[testLens.size()]);
    }

    private final Integer[] generateTestOffsets(int j) {
        HashSet<Integer> testOffsets = new HashSet<Integer>();
        for (int testOffset : new int[]{0, j / 2, j - 1}) {
            if (testOffset >= j - 1) continue;
            testOffsets.add(testOffset);
        }
        return testOffsets.toArray(new Integer[testOffsets.size()]);
    }

    private static abstract class AbstractMethodTester {
        private final byte[] testInputData;
        private final File dumpFile;
        private Channel channelToDump;
        private final FileChannel dumpChannel;
        private final ByteArrayOutputStream soFarProcessedBytesOutputStream;
        private byte[] lastProcessedBytes;

        protected AbstractMethodTester(File dumpFile, byte[] testInputData) throws IOException {
            assert (dumpFile != null);
            assert (testInputData != null);
            this.testInputData = testInputData;
            this.dumpFile = dumpFile;
            this.channelToDump = null;
            this.dumpChannel = ByteChannelDumpHelper.createDumpFileChannel((File)dumpFile);
            this.soFarProcessedBytesOutputStream = new ByteArrayOutputStream();
            this.lastProcessedBytes = null;
        }

        protected final void setLastProcessedBytes(byte[] lastProcessedBytes) {
            this.lastProcessedBytes = lastProcessedBytes;
        }

        protected abstract void updateSoFarProcessedBytes(byte[] var1) throws IOException;

        protected final ByteArrayOutputStream getSoFarProcessedBytesOutputStream() {
            return this.soFarProcessedBytesOutputStream;
        }

        protected final byte[] getTestInputData() {
            return this.testInputData;
        }

        public abstract int callMethodOnce() throws IOException;

        private final void checkProcessedAndDumpedBytes() throws IOException {
            byte[] soFarWrittenBytes = this.soFarProcessedBytesOutputStream.toByteArray();
            byte[] dumpedBytes = IOHelper.readFileAsBytes((File)this.dumpFile);
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(this.testInputData, 0, soFarWrittenBytes.length), (byte[])soFarWrittenBytes);
            Assert.assertArrayEquals((byte[])soFarWrittenBytes, (byte[])dumpedBytes);
        }

        protected final Channel getChannelToDump() {
            if (this.channelToDump == null) {
                this.channelToDump = this.createTestChannelToDump();
            }
            return this.channelToDump;
        }

        protected final FileChannel getDumpChannel() {
            return this.dumpChannel;
        }

        protected abstract Channel createTestChannelToDump();

        protected void check() throws IOException {
            this.checkProcessedAndDumpedBytes();
        }

        public final void testCallUntilEndOfStream() throws IOException {
            while (true) {
                this.setLastProcessedBytes(null);
                this.callMethodOnce();
                if (this.lastProcessedBytes == null) break;
                this.updateSoFarProcessedBytes(this.lastProcessedBytes);
                this.check();
            }
        }
    }

    private static abstract class AbstractBufferByBufferMethodTester
    extends AbstractMethodTester {
        private final byte[] byteBuffer;
        private final int offset;
        private final int len;

        protected AbstractBufferByBufferMethodTester(byte[] byteBuffer, int offset, int len, File dumpFile, byte[] testInputData) throws IOException {
            super(dumpFile, testInputData);
            assert (byteBuffer != null);
            this.byteBuffer = byteBuffer;
            this.offset = offset;
            this.len = len;
        }

        protected final byte[] getByteBuffer() {
            return this.byteBuffer;
        }

        protected final int getOffset() {
            return this.offset;
        }

        protected final int getLen() {
            return this.len;
        }
    }

    private static class BufferByBufferWriteTester
    extends AbstractBufferByBufferMethodTester {
        public BufferByBufferWriteTester(byte[] byteBuffer, int offset, int len, File dumpFile, byte[] testInputData) throws IOException {
            super(byteBuffer, offset, len, dumpFile, testInputData);
        }

        @Override
        protected void updateSoFarProcessedBytes(byte[] lastProcessedBytes) throws IOException {
        }

        @Override
        protected WritableByteChannel createTestChannelToDump() {
            return Channels.newChannel(this.getSoFarProcessedBytesOutputStream());
        }

        protected int doCallMethodOnceIfBufferCanBeFullyFilled() throws IOException {
            System.arraycopy(this.getTestInputData(), this.getSoFarProcessedBytesOutputStream().size(), this.getByteBuffer(), this.getOffset(), this.getLen());
            ByteChannelDumpHelper.dumpAndWrite((WritableByteChannel)((WritableByteChannel)this.getChannelToDump()), (ByteBuffer)ByteBuffer.wrap(this.getByteBuffer(), this.getOffset(), this.getLen()), (FileChannel)this.getDumpChannel());
            this.setLastProcessedBytes(Arrays.copyOfRange(this.getByteBuffer(), this.getOffset(), this.getOffset() + this.getLen()));
            return this.getLen();
        }

        @Override
        public final int callMethodOnce() throws IOException {
            int nbSoFarWrittenBytes = this.getSoFarProcessedBytesOutputStream().size();
            if (nbSoFarWrittenBytes == this.getTestInputData().length) {
                return -1;
            }
            int remainingNbBytesToWrite = this.getTestInputData().length - nbSoFarWrittenBytes;
            if (this.getOffset() + this.getLen() <= this.getByteBuffer().length && remainingNbBytesToWrite < this.getLen()) {
                return -1;
            }
            return this.doCallMethodOnceIfBufferCanBeFullyFilled();
        }
    }

    private static class BufferByBufferReadTester
    extends AbstractBufferByBufferMethodTester {
        protected byte[] byteBufferBeforeReadCall = null;

        public BufferByBufferReadTester(byte[] byteBuffer, int offset, int len, File dumpFile, byte[] testInputData) throws IOException {
            super(byteBuffer, offset, len, dumpFile, testInputData);
        }

        @Override
        protected ReadableByteChannel createTestChannelToDump() {
            return Channels.newChannel(new ByteArrayInputStream(this.getTestInputData()));
        }

        @Override
        protected void updateSoFarProcessedBytes(byte[] lastProcessedBytes) throws IOException {
            this.getSoFarProcessedBytesOutputStream().write(lastProcessedBytes);
        }

        @Override
        public int callMethodOnce() throws IOException {
            this.byteBufferBeforeReadCall = Arrays.copyOf(this.getByteBuffer(), this.getByteBuffer().length);
            ByteBuffer testBuffer = ByteBuffer.wrap(this.getByteBuffer(), this.getOffset(), this.getLen());
            int lastNbRead = ByteChannelDumpHelper.dumpAndRead((ReadableByteChannel)((ReadableByteChannel)this.getChannelToDump()), (ByteBuffer)testBuffer, (FileChannel)this.getDumpChannel());
            if (lastNbRead != -1) {
                this.setLastProcessedBytes(Arrays.copyOfRange(this.getByteBuffer(), this.getOffset(), this.getOffset() + lastNbRead));
            }
            return lastNbRead;
        }

        @Override
        protected void check() throws IOException {
            super.check();
            this.checkByteBufferUntouchedBeforeDestBytes();
            this.checkByteBufferUntouchedAfterDestBytes();
        }

        private void checkByteBufferUntouchedBeforeDestBytes() {
            byte[] originalBytesBeforeDestBytes = Arrays.copyOfRange(this.byteBufferBeforeReadCall, 0, this.getOffset());
            byte[] modifiedBytesBeforeDestBytes = Arrays.copyOfRange(this.getByteBuffer(), 0, this.getOffset());
            Assert.assertArrayEquals((byte[])originalBytesBeforeDestBytes, (byte[])modifiedBytesBeforeDestBytes);
        }

        private void checkByteBufferUntouchedAfterDestBytes() {
            byte[] originalBytesAfterDestBytes = Arrays.copyOfRange(this.byteBufferBeforeReadCall, this.getOffset() + this.getLen(), this.byteBufferBeforeReadCall.length);
            byte[] modifiedBytesAfterDestBytes = Arrays.copyOfRange(this.getByteBuffer(), this.getOffset() + this.getLen(), this.byteBufferBeforeReadCall.length);
            Assert.assertArrayEquals((byte[])originalBytesAfterDestBytes, (byte[])modifiedBytesAfterDestBytes);
        }
    }

    private static abstract class AbstractMethodTesterBuilder {
        protected byte[] testInputData = null;
        protected File dumpFile = null;
        protected byte[] byteBuffer = null;
        protected int offset = 0;
        protected int len = 0;

        public final void setTestInputData(byte[] testInputData) {
            this.testInputData = testInputData;
        }

        public final void setDumpFile(File dumpFile) {
            this.dumpFile = dumpFile;
        }

        public final void setOffset(int offset) {
            this.offset = offset;
        }

        public final void setLen(int len) {
            this.len = len;
        }

        public final void setByteBuffer(byte[] byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        protected abstract AbstractMethodTester build() throws IOException;
    }

    private static class BufferByBufferWriteTesterBuilder
    extends AbstractMethodTesterBuilder {
        private BufferByBufferWriteTesterBuilder() {
        }

        @Override
        protected AbstractMethodTester build() throws IOException {
            return new BufferByBufferWriteTester(this.byteBuffer, this.offset, this.len, this.dumpFile, this.testInputData);
        }
    }

    private static class BufferByBufferReadTesterBuilder
    extends AbstractMethodTesterBuilder {
        private BufferByBufferReadTesterBuilder() {
        }

        @Override
        protected AbstractMethodTester build() throws IOException {
            return new BufferByBufferReadTester(this.byteBuffer, this.offset, this.len, this.dumpFile, this.testInputData);
        }
    }
}

