/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import java.io.File;
import java.io.IOException;
import java.util.Random;

public final class FileSystemHelper {
    private static final String ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NULL = "The source path is null";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION_MSG_TARGET_NULL = "The target path is null";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NOT_ABSOLUTE = "The source is not an absolute directory";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NOT_DIR = "The source is not an directory";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION_MSG_TARGET_NOT_ABSOLUTE = "The target is not an absolute path";
    private static final Random random = new Random();

    private FileSystemHelper() {
    }

    private static final File getSystemTempDir() {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        assert (tmpDirPath != null);
        File tmpDir = new File(tmpDirPath);
        assert (tmpDir != null);
        return tmpDir;
    }

    public static File createTempDir() throws IOException {
        return FileSystemHelper.createTempDir(FileSystemHelper.getSystemTempDir(), "tmp");
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileSystemHelper.createTempDir(FileSystemHelper.getSystemTempDir(), prefix);
    }

    public static File createTempDir(File parentDir, String prefix) throws IOException {
        File tempDir = null;
        while ((tempDir = new File(parentDir, prefix + random.nextLong())).exists()) {
        }
        if (!tempDir.mkdir()) {
            throw new IOException(String.format("Impossible to create temp dir '%s'", tempDir.getAbsolutePath()));
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static void cleanDirectory(File directory) throws IOException {
        assert (directory != null);
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IOException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IOException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileSystemHelper.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        assert (file != null);
        if (file.isDirectory()) {
            FileSystemHelper.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                return;
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    private static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileSystemHelper.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    @Deprecated
    public static String getRelativePath(String source, String target) {
        int i;
        String[] targets;
        String[] sources;
        String targetFile = null;
        if (!source.endsWith(File.separator)) {
            throw new IllegalArgumentException();
        }
        if (!target.endsWith(File.separator)) {
            int lastFolderIndex = target.lastIndexOf(File.separator) + 1;
            targetFile = target.substring(lastFolderIndex);
            target = target.substring(0, lastFolderIndex);
        }
        int length = (sources = source.split(File.separator)).length < (targets = target.split(File.separator)).length ? sources.length : targets.length;
        for (int common = 0; common < length && sources[common].equals(targets[common]); ++common) {
        }
        StringBuilder relativePathBuilder = new StringBuilder();
        for (i = common; i < sources.length; ++i) {
            relativePathBuilder.append(".." + File.separator);
        }
        for (i = common; i < targets.length; ++i) {
            relativePathBuilder.append(targets[i] + File.separator);
        }
        if (targetFile != null) {
            relativePathBuilder.append(targetFile);
        }
        return relativePathBuilder.toString();
    }

    public static String getRelativePath(File sourcePath, File targetPath) {
        int common;
        String[] targets;
        if (sourcePath == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NULL);
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_EXCEPTION_MSG_TARGET_NULL);
        }
        if (!sourcePath.isAbsolute()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NOT_ABSOLUTE);
        }
        if (!sourcePath.isDirectory()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NOT_DIR);
        }
        if (!targetPath.isAbsolute()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_EXCEPTION_MSG_TARGET_NOT_ABSOLUTE);
        }
        String source = sourcePath.getAbsolutePath().substring(1);
        String target = targetPath.getAbsolutePath().substring(1);
        String[] sources = source.split(File.separator);
        int length = sources.length < (targets = target.split(File.separator)).length ? sources.length : targets.length;
        for (common = 0; common < length && sources[common].equals(targets[common]); ++common) {
        }
        if (common > 0) {
            int i;
            StringBuilder relativePathBuilder = new StringBuilder();
            if (common == sources.length) {
                relativePathBuilder.append(".").append(File.separator);
            }
            for (i = common; i < sources.length; ++i) {
                relativePathBuilder.append("..").append(File.separator);
            }
            for (i = common; i < targets.length; ++i) {
                relativePathBuilder.append(targets[i]);
                if (i >= targets.length - 1) continue;
                relativePathBuilder.append(File.separator);
            }
            return relativePathBuilder.toString();
        }
        return targetPath.getAbsolutePath();
    }
}

