/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class ZipHelper {

	/**
	 * Extract all the archive entries with a name starting with the specified
	 * name prefix to the specified destination directory
	 * 
	 * @param archive
	 *            the archive which contains the entries to extract
	 * @param entryNamePrefix
	 *            the name prefix of entries to extract from the archive
	 * @param absoluteDestDir
	 *            the directory to extract the archive entries
	 * @throws IOException
	 *             if an I/O entry has occurred
	 */
	public static void extractEntriesFromArchive(ZipFile archive, String entryNamePrefix, File destDir) throws IOException {
		assert archive != null;
		assert entryNamePrefix != null;
		assert destDir != null && destDir.isDirectory();
    	
    	Enumeration<? extends ZipEntry> entries = archive.entries();
    	while(entries.hasMoreElements()) {
    		ZipEntry entry = entries.nextElement();
        	String entryName = entry.getName();
    		if(entryName.startsWith(entryNamePrefix)) {
    			if(entry.isDirectory()) {
					File extractedFile = new File(destDir, entryName);
					extractedFile.mkdirs();
    			} else {
	            	InputStream inputStream = archive.getInputStream(entry);
					File extractedFile = new File(destDir, entryName);
					extractedFile.getParentFile().mkdirs();
					FileOutputStream fileOutputStream = new FileOutputStream(extractedFile);
	            	byte[] buffer = new byte[2048];
	            	int length = inputStream.read(buffer); 
	            	while(length > 0) {
	            		fileOutputStream.write(buffer, 0, length);
	                	length = inputStream.read(buffer); 
	            	}
    			}
    		}
    	}
		
	}


}
