/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.lang;

import com.ebmwebsourcing.easycommons.lang.ArrayHelper;
import org.junit.Assert;
import org.junit.Test;

public class ArrayHelperTest {
    @Test
    public void testMergeArrays0() throws Exception {
        Object[] mergedArray = (Integer[])ArrayHelper.mergeArrays((Object[][])new Integer[][]{new Integer[0]});
        Assert.assertArrayEquals((Object[])new Integer[0], (Object[])mergedArray);
    }

    @Test
    public void testMergeArrays1() throws Exception {
        Object[] mergedArray = (Integer[])ArrayHelper.mergeArrays((Object[][])new Integer[][]{new Integer[0], new Integer[0], new Integer[0]});
        Assert.assertArrayEquals((Object[])new Integer[0], (Object[])mergedArray);
    }

    @Test
    public void testMergeArrays2() throws Exception {
        Object[] mergedArray = (Integer[])ArrayHelper.mergeArrays((Object[][])new Integer[][]{{1, 2, 3}, {4, 5}, {6}});
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3, 4, 5, 6}, (Object[])mergedArray);
    }

    @Test
    public void testArrayRemove0() throws Exception {
        Object[] originalArray = new Integer[]{1, 2, 3, 4, 5, 6};
        Object[] result = (Integer[])ArrayHelper.arrayRemove((Object[])originalArray, (Object[])new Integer[0]);
        Assert.assertArrayEquals((Object[])originalArray, (Object[])result);
    }

    @Test
    public void testArrayRemove1() throws Exception {
        Object[] originalArray = new Integer[]{1, 2, 3, 4, 5, 6};
        Object[] result = (Integer[])ArrayHelper.arrayRemove((Object[])originalArray, (Object[])new Integer[]{7, 8, 9});
        Assert.assertArrayEquals((Object[])originalArray, (Object[])result);
    }

    @Test
    public void testArrayRemove2() throws Exception {
        Object[] originalArray = new Integer[]{1, 2, 3, 4, 5, 6};
        Object[] result = (Integer[])ArrayHelper.arrayRemove((Object[])originalArray, (Object[])new Integer[]{2, 3, 5});
        Assert.assertArrayEquals((Object[])new Integer[]{1, 4, 6}, (Object[])result);
    }

    @Test
    public void testArrayContainsSameObject0() throws Exception {
        StringBuffer s1 = new StringBuffer("s1");
        StringBuffer s2 = new StringBuffer("s2");
        StringBuffer s3 = new StringBuffer("s3");
        Object[] array = new StringBuffer[]{s1, s2, s3};
        for (StringBuffer s : new StringBuffer[]{s1, s2, s3}) {
            Assert.assertTrue((boolean)ArrayHelper.arrayContainsSameObject((Object[])array, (Object)s));
        }
    }

    @Test
    public void testArrayContainsSameObject1() throws Exception {
        StringBuffer s1 = new StringBuffer("s1");
        StringBuffer s2 = new StringBuffer("s2");
        StringBuffer s3 = new StringBuffer("s3");
        Object[] array = new StringBuffer[]{s1, s2, s3};
        for (StringBuffer s : new StringBuffer[]{new StringBuffer("s1"), new StringBuffer("s2"), new StringBuffer("s3")}) {
            Assert.assertFalse((boolean)ArrayHelper.arrayContainsSameObject((Object[])array, (Object)s));
        }
    }
}

