/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.lang.reflect;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.lang.reflect.ClassWithStaticMethods;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionHelperTest {
    @Test
    public void testFindAllImplementedInterfaces0() throws Exception {
        Set implementedInterfaces = ReflectionHelper.findAllImplementedInterfaces(ClassD.class);
        HashSet expectedImplementedInterfaces = new HashSet();
        Assert.assertEquals(expectedImplementedInterfaces, (Object)implementedInterfaces);
    }

    @Test
    public void testFindAllImplementedInterfaces1() throws Exception {
        Set implementedInterfaces = ReflectionHelper.findAllImplementedInterfaces(ClassA.class);
        HashSet<Class> expectedImplementedInterfaces = new HashSet<Class>();
        expectedImplementedInterfaces.add(InterfaceA.class);
        expectedImplementedInterfaces.add(InterfaceB.class);
        Assert.assertEquals(expectedImplementedInterfaces, (Object)implementedInterfaces);
    }

    @Test
    public void testFindAllImplementedInterfaces2() throws Exception {
        Set implementedInterfaces = ReflectionHelper.findAllImplementedInterfaces(ClassB.class);
        HashSet<Class> expectedImplementedInterfaces = new HashSet<Class>();
        expectedImplementedInterfaces.add(InterfaceA.class);
        expectedImplementedInterfaces.add(InterfaceB.class);
        Assert.assertEquals(expectedImplementedInterfaces, (Object)implementedInterfaces);
    }

    @Test
    public void testFindAllImplementedInterfaces3() throws Exception {
        Set implementedInterfaces = ReflectionHelper.findAllImplementedInterfaces(ClassC.class);
        HashSet<Class<InterfaceE>> expectedImplementedInterfaces = new HashSet<Class<InterfaceE>>();
        expectedImplementedInterfaces.add(InterfaceA.class);
        expectedImplementedInterfaces.add(InterfaceB.class);
        expectedImplementedInterfaces.add(InterfaceC.class);
        expectedImplementedInterfaces.add(InterfaceD.class);
        expectedImplementedInterfaces.add(InterfaceE.class);
        Assert.assertEquals(expectedImplementedInterfaces, (Object)implementedInterfaces);
    }

    @Test
    public void testFindMethodThatReturnString() throws Exception {
        Collection methods = ReflectionHelper.findMethodsThatReturnType(ClassE.class, String.class);
        Assert.assertEquals((long)2L, (long)methods.size());
        Iterator it = methods.iterator();
        Assert.assertEquals((Object)"methodString", (Object)((Method)it.next()).getName());
        Assert.assertEquals((Object)"toString", (Object)((Method)it.next()).getName());
    }

    @Test
    public void testFindMethodThatReturnInt() throws Exception {
        Collection methods = ReflectionHelper.findMethodsThatReturnType(ClassE.class, Integer.TYPE);
        Assert.assertEquals((long)2L, (long)methods.size());
        Iterator it = methods.iterator();
        Assert.assertEquals((Object)"methodInt", (Object)((Method)it.next()).getName());
        Assert.assertEquals((Object)"hashCode", (Object)((Method)it.next()).getName());
    }

    @Test(expected=UncheckedException.class)
    public void testGetMethod0() throws Exception {
        ReflectionHelper.getPublicMethod(ClassB.class, (String)"wrongMethodName", (Class[])new Class[0]);
    }

    @Test(expected=UncheckedException.class)
    public void testGetMethod1() throws Exception {
        ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodA", (Class[])new Class[]{String.class});
    }

    @Test
    public void testGetMethod2() throws Exception {
        Assert.assertEquals((Object)ClassB.class.getMethod("methodA", new Class[0]), (Object)ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodA", (Class[])new Class[0]));
    }

    @Test(expected=UncheckedException.class)
    public void testGetMethod3() throws Exception {
        ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodB", (Class[])new Class[]{Integer.TYPE});
    }

    @Test
    public void testGetMethod4() throws Exception {
        ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodC", (Class[])new Class[]{Integer.TYPE});
    }

    @Test
    public void testGetPublicDeclaredMethods0() throws Exception {
        List actualMethods = ReflectionHelper.getPublicDeclaredMethods(ClassE.class);
        Assert.assertEquals((long)2L, (long)actualMethods.size());
        Iterator it = actualMethods.iterator();
        Assert.assertEquals((Object)"methodString", (Object)((Method)it.next()).getName());
        Assert.assertEquals((Object)"methodInt", (Object)((Method)it.next()).getName());
    }

    @Test
    public void testGetPublicDeclaredMethods1() throws Exception {
        List actualMethods = ReflectionHelper.getPublicDeclaredMethods(ClassC.class);
        Assert.assertEquals((long)0L, (long)actualMethods.size());
    }

    @Test
    public void testinvokeMethod0() throws Exception {
        ClassB objectB = new ClassB();
        ReflectionHelper.invokeMethod((Object)objectB, (Method)ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodA", (Class[])new Class[0]), (Object[])new Object[0]);
    }

    @Test
    public void testinvokePrivateMethodDeprecated_0() throws Exception {
        ClassE objectE = new ClassE();
        ReflectionHelper.invokePrivateMethod((Object)objectE, (String)"methodA", (Object[])new Object[]{5});
    }

    @Test
    public void testinvokePrivateMethod0() throws Exception {
        ClassE objectE = new ClassE();
        ReflectionHelper.invokePrivateMethod((Object)objectE, (String)"methodA", (Object[])new Object[]{5}, (Class[])new Class[]{Integer.class});
    }

    @Test
    public void testinvokePrivateMethod1() throws Exception {
        ClassE objectE = new ClassE();
        ArrayList list = new ArrayList();
        ReflectionHelper.invokePrivateMethod((Object)objectE, (String)"methodList", (Object[])new Object[]{list}, (Class[])new Class[]{List.class});
    }

    @Test
    public void testinvokePrivateMethod_StaticPrivateMethod() throws Exception {
        String string = "string";
        Assert.assertEquals((Object)"string", (Object)ReflectionHelper.invokePrivateMethod(ClassWithStaticMethods.class, null, (String)"myMethod", (Object[])new Object[]{"string"}, (Class[])new Class[]{String.class}));
    }

    @Test(expected=UncheckedException.class)
    public void testinvokePrivateMethod_NullNull() throws Exception {
        ReflectionHelper.invokePrivateMethod(null, null, (String)"myMethod", (Object[])new Object[0], (Class[])new Class[0]);
    }

    @Test
    public void testinvokeMethod1() throws Exception {
        ClassB objectB = new ClassB();
        ReflectionHelper.invokeMethod((Object)objectB, (Method)ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodC", (Class[])new Class[]{Integer.TYPE}), (Object[])new Object[]{5});
    }

    @Test(expected=UncheckedException.class)
    public void testinvokeMethod2() throws Exception {
        ClassB objectB = new ClassB();
        ReflectionHelper.invokeMethod((Object)objectB, (Method)ReflectionHelper.getPublicMethod(ClassB.class, (String)"methodA", (Class[])new Class[0]), (Object[])new Object[]{"Illegal argument"});
    }

    @Test(expected=UncheckedException.class)
    public void testinvokeMethod3() throws Exception {
        ClassB objectB = new ClassB();
        ReflectionHelper.invokeMethod((Object)objectB, (Method)ClassB.class.getDeclaredMethod("methodB", Integer.TYPE), (Object[])new Object[]{5});
    }

    @Test
    public void testNewInstance0() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Assert.assertNotNull((Object)objectD);
    }

    @Test(expected=UncheckedException.class)
    public void testNewInstance1() throws Exception {
        ReflectionHelper.newInstance(ClassB.class, (Object[])new Object[0]);
    }

    @Test(expected=UncheckedException.class)
    public void testNewInstance2() throws Exception {
        ReflectionHelper.newInstance(ClassA.class, (Object[])new Object[0]);
    }

    @Test(expected=UncheckedException.class)
    public void testNewInstance3() throws Exception {
        ReflectionHelper.newInstance(ClassB.class, (Object[])new Object[0]);
    }

    @Test
    public void testLoadClassWithNullClassloader() throws Exception {
        Class a = ReflectionHelper.loadClass((String)ReflectionHelper.class.getName(), null);
        Assert.assertTrue((boolean)a.getName().equals(ReflectionHelper.class.getName()));
    }

    @Test
    public void testLoadClassWithClassloader() throws Exception {
        Class a = ReflectionHelper.loadClass((String)ReflectionHelper.class.getName(), (ClassLoader)ReflectionHelperTest.class.getClassLoader());
        Assert.assertTrue((boolean)a.getName().equals(ReflectionHelper.class.getName()));
    }

    @Test(expected=UncheckedException.class)
    public void testLoadClassWithUnknownClass() throws Exception {
        ReflectionHelper.loadClass((String)"UnknownClass", null);
    }

    @Test(expected=UncheckedException.class)
    public void testGetFieldValue0() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        ReflectionHelper.getFieldValue((Object)objectD, (Field)field1);
    }

    @Test(expected=UncheckedException.class)
    public void testGetFieldValue1() throws Exception {
        ClassA objectA = (ClassA)ReflectionHelper.newInstance(ClassA.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        ReflectionHelper.getFieldValue((Object)objectA, (Field)field1);
    }

    @Test
    public void testGetFieldValue2() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        field1.setAccessible(true);
        Assert.assertEquals((Object)0, (Object)ReflectionHelper.getFieldValue((Object)objectD, (Field)field1));
    }

    @Test(expected=UncheckedException.class)
    public void testSetFieldValue0() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        ReflectionHelper.setFieldValue((Object)objectD, (Field)field1, (Object)5);
    }

    @Test(expected=UncheckedException.class)
    public void testSetFieldValue1() throws Exception {
        ClassA objectA = (ClassA)ReflectionHelper.newInstance(ClassA.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        ReflectionHelper.setFieldValue((Object)objectA, (Field)field1, (Object)5);
    }

    @Test(expected=UncheckedException.class)
    public void testSetFieldValue2() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        field1.setAccessible(true);
        ReflectionHelper.setFieldValue((Object)objectD, (Field)field1, (Object)"5");
    }

    @Test
    public void testSetFieldValue3() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Field field1 = ClassD.class.getDeclaredField("field1");
        field1.setAccessible(true);
        ReflectionHelper.setFieldValue((Object)objectD, (Field)field1, (Object)5);
    }

    @Test
    public void testIsOrInheritedFromWithAClassAndItsCanonicalName() {
        Assert.assertTrue((boolean)ReflectionHelper.isOrInheritedFrom(ClassA.class, (String)(this.getClass().getCanonicalName() + ".ClassA")));
    }

    @Test
    public void testIsOrInheritedFromWithAClassAndACanonicalNameWhichIsNotOneOfItsSuperclassName() {
        Assert.assertTrue((!ReflectionHelper.isOrInheritedFrom(ClassA.class, (String)(this.getClass().getCanonicalName() + ".ClassX")) ? 1 : 0) != 0);
    }

    @Test
    public void testIsOrInheritedFromWithAClassAndACanonicalNameOfOneOfItsSuperclass() {
        Assert.assertTrue((boolean)ReflectionHelper.isOrInheritedFrom(ClassC.class, (String)(this.getClass().getCanonicalName() + ".ClassA")));
    }

    @Test
    public void testIsOrInheritedFromWithAInterfaceAndACanonicalNameOfOneOfItsSuperclass() {
        ClassC interfaceE = new ClassC();
        Assert.assertTrue((boolean)ReflectionHelper.isOrInheritedFrom(interfaceE.getClass(), (String)(this.getClass().getCanonicalName() + ".ClassA")));
    }

    @Test
    public void testSetAndGetPrivateFieldValue_0() throws Exception {
        ClassD objectD = (ClassD)ReflectionHelper.newInstance(ClassD.class, (Object[])new Object[0]);
        Assert.assertNotNull((Object)objectD);
        int expectedValue = 100;
        ReflectionHelper.setPrivateField((Object)objectD, (String)"field1", (Object)100);
        int value = (Integer)ReflectionHelper.getPrivateFieldValue(ClassD.class, (Object)objectD, (String)"field1");
        Assert.assertEquals((long)100L, (long)value);
    }

    public class ClassE {
        private void methodA(Integer param1) {
        }

        private void methodList(List<String> param1) {
        }

        public String methodString() {
            return "0";
        }

        public int methodInt() {
            return 0;
        }
    }

    private static final class ClassD {
        private int field1 = 0;
    }

    private static final class ClassC
    extends ClassB
    implements InterfaceA,
    InterfaceE,
    InterfaceD {
        private ClassC() {
        }
    }

    private static class ClassB
    extends ClassA {
        private ClassB() {
        }

        @Override
        public final void methodA() {
        }

        private final void methodB(int param1) {
        }

        public final void methodC(int param1) {
        }
    }

    private static abstract class ClassA
    implements InterfaceA,
    InterfaceB {
    }

    private static interface InterfaceE
    extends InterfaceC {
    }

    private static interface InterfaceD {
    }

    private static interface InterfaceC {
    }

    private static interface InterfaceB {
        public void methodA();
    }

    private static interface InterfaceA {
    }
}

