/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.AbstractLogDataFormatterTest;
import com.ebmwebsourcing.easycommons.logger.BasicLogDataAppender;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.LogDataAppender;
import com.ebmwebsourcing.easycommons.logger.LogDataFormatter;
import com.ebmwebsourcing.easycommons.logger.LogRecordHelper;
import com.ebmwebsourcing.easycommons.logger.TestLogData;
import com.ebmwebsourcing.easycommons.time.SimulatedTime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.LogRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogDataFormatterTest
extends AbstractLogDataFormatterTest {
    protected static final String INFORMATIONAL_MESS_PART = "This is a test message";
    protected SimulatedTime time = null;
    protected long utcTime = 0L;
    protected String formattedDate = null;

    @Before
    public void initSimulatedTime() {
        this.time = new SimulatedTime();
        this.time.pause();
        this.utcTime = this.time.getUtcTime();
        this.formattedDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss,SSS 'GMT'Z", Locale.getDefault()).format(this.utcTime);
    }

    @Test
    public final void testNoLogDataAppenderPresentByDefault() {
        LogDataFormatter formatter = new LogDataFormatter();
        Assert.assertEquals((long)0L, (long)formatter.getLogDataAppenders().length);
    }

    @Test
    public final void testAddDataAppender() {
        LogDataFormatter formatter = new LogDataFormatter();
        BasicLogDataAppender blda1 = new BasicLogDataAppender();
        BasicLogDataAppender blda2 = new BasicLogDataAppender();
        formatter.addLogDataAppender((LogDataAppender)blda1);
        formatter.addLogDataAppender((LogDataAppender)blda2);
        Assert.assertArrayEquals((Object[])new LogDataAppender[]{blda1, blda2}, (Object[])formatter.getLogDataAppenders());
    }

    @Test
    public final void testFormatMessageWithoutLogData() throws Exception {
        LogDataFormatter formatter = new LogDataFormatter();
        String msg = "This is a test {0} message";
        LogRecord logRecord = LogRecordHelper.newLogRecord(Level.INFO, msg, this.utcTime);
        logRecord.setParameters(new Object[]{"REPLACED"});
        String myLog = formatter.formatMessage(logRecord);
        Assert.assertEquals((Object)"This is a test REPLACED message", (Object)myLog);
    }

    @Test
    public final void testFormatMessageWithLogData() throws Exception {
        LogDataFormatter formatter = new LogDataFormatter();
        String msg = "This is a test {0} message";
        LogRecord logRecord = LogRecordHelper.newLogRecord(Level.INFO, msg, this.utcTime);
        logRecord.setParameters(new Object[]{LogDataFormatterTest.createTestLogData()});
        String myLog = formatter.formatMessage(logRecord);
        Assert.assertEquals((Object)"This is a test {0} message", (Object)myLog);
    }

    @Test
    public final void testFormattingWithoutExceptionNoRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        this.testFormatting(formatterUnderTest, null, null, null, "");
    }

    @Test
    public final void testFormattingWithExceptionNoRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        RuntimeException thrown = new RuntimeException("error...");
        this.testFormatting(formatterUnderTest, null, thrown, null, "");
    }

    @Test
    public final void testFormattingWithExceptionChainNoRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        RuntimeException cause2 = new RuntimeException("error cause2...");
        RuntimeException cause1 = new RuntimeException("error cause1...", cause2);
        RuntimeException thrown = new RuntimeException("error...", cause1);
        this.testFormatting(formatterUnderTest, null, thrown, null, "");
    }

    @Test
    public final void testFormattingWithoutExceptionUnhandledRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        this.testFormatting(formatterUnderTest, new Object[]{1, "fakeparam", 2.3}, null, null, "");
    }

    @Test
    public final void testFormattingWithoutExceptionLogDataAsRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        formatterUnderTest.addLogDataAppender((LogDataAppender)new BasicLogDataAppender());
        this.testFormatting(formatterUnderTest, new Object[]{LogDataFormatterTest.createTestLogData()}, null, null, " {{key1 = 'value1', key2 = 'value2', key3 = 'value3'}}");
    }

    @Test
    public final void testFormattingWithoutExceptionEmptyLogDataAsRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        formatterUnderTest.addLogDataAppender((LogDataAppender)new BasicLogDataAppender());
        this.testFormatting(formatterUnderTest, new Object[]{new TestLogData()}, null, null, "");
    }

    @Test
    public final void testFormattingWithoutExceptionLogDataAsRecordParamButNoAppender() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        this.testFormatting(formatterUnderTest, new Object[]{LogDataFormatterTest.createTestLogData()}, null, null, "");
    }

    @Test
    public final void testFormattingWithExceptionLogDataAsRecordParam() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        formatterUnderTest.addLogDataAppender((LogDataAppender)new BasicLogDataAppender());
        RuntimeException thrown = new RuntimeException("error...");
        this.testFormatting(formatterUnderTest, new Object[]{LogDataFormatterTest.createTestLogData()}, thrown, null, " {{key1 = 'value1', key2 = 'value2', key3 = 'value3'}}");
    }

    @Test
    public final void testFormatMessageWithNullAsParametersValue() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        this.testFormatting(formatterUnderTest, null, null, null, "");
    }

    @Test
    public final void testFormatMessageWithNullAsFirstValueInParameters() throws Exception {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        this.testFormatting(formatterUnderTest, new String[]{null}, null, null, "");
    }

    @Test
    public void testFormatMessageWithPrefix() {
        LogDataFormatter formatterUnderTest = new LogDataFormatter();
        String expectedPrefix = "petals-node1";
        formatterUnderTest.setPrefix(expectedPrefix);
        this.testFormatting(formatterUnderTest, new Object[]{LogDataFormatterTest.createTestLogData()}, null, expectedPrefix, "");
    }

    protected void testFormatting(LogDataFormatter formatterUnderTest, Object[] logDataParameters, Throwable thrown, String expectedPrefix, String expectedExtraParametersMessPart) {
        for (java.util.logging.Level level : Level.getLevels()) {
            LogRecord logRecord;
            LogRecord logRecord2 = logRecord = thrown != null ? LogRecordHelper.newLogRecordWithException(level, INFORMATIONAL_MESS_PART, this.utcTime, thrown) : LogRecordHelper.newLogRecord(level, INFORMATIONAL_MESS_PART, this.utcTime);
            if (logDataParameters != null) {
                logRecord.setParameters(logDataParameters);
            }
            String expectedLogMessage = (expectedPrefix != null ? expectedPrefix + " " : "") + this.formattedDate + " " + level + " [" + logRecord.getLoggerName() + "] : " + INFORMATIONAL_MESS_PART + expectedExtraParametersMessPart + "\n" + (thrown != null ? this.generateExpectedExceptionMessagePart(thrown) : "");
            String myLog = formatterUnderTest.format(logRecord);
            Assert.assertEquals((Object)expectedLogMessage, (Object)myLog);
        }
    }

    protected String generateExpectedExceptionMessagePart(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        sw.flush();
        return sw.toString();
    }
}

