/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.LoggerHelper;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class LoggerHelperTest {
    @Test
    public void testGetLevelOrParentLevelOnChildOfRootLogger() {
        Logger logger = Logger.getLogger("myChildLogger0");
        Assert.assertNotNull((Object)LoggerHelper.getLevelOrParentLevel((Logger)logger));
    }

    @Test
    public void testGetLevelOrParentLevelOnChildOfUserLogger() {
        Logger parentLogger = Logger.getLogger("myParentLogger1");
        parentLogger.setLevel(Level.FINEST);
        Logger childLogger = Logger.getLogger("myParentLogger1.myChildLogger1");
        Assert.assertSame((Object)parentLogger.getLevel(), (Object)LoggerHelper.getLevelOrParentLevel((Logger)childLogger));
    }

    @Test
    public void testGetLevelOrParentLevelOnLittleChildUserLogger() {
        Logger parentLogger = Logger.getLogger("myParentLogger2");
        parentLogger.setLevel(Level.FINEST);
        Logger littleChildLogger = Logger.getLogger("myParentLogger2.myChildLogger2.myLittleChildLogger2");
        Assert.assertSame((Object)parentLogger.getLevel(), (Object)LoggerHelper.getLevelOrParentLevel((Logger)littleChildLogger));
    }

    @Test
    public void testGetLevelOrParentLevelOnChildOfUserLoggerWhenSpecificLevelGiven() {
        Logger parentLogger = Logger.getLogger("myParentLogger3");
        Logger childLogger = Logger.getLogger("myParentLogger3.myChild3");
        childLogger.setLevel(Level.SEVERE);
        parentLogger.setLevel(Level.INFO);
        Assert.assertEquals((Object)Level.SEVERE, (Object)LoggerHelper.getLevelOrParentLevel((Logger)childLogger));
    }

    @Test
    public void testGetHandlersOrParentHanderslOnChildOfRootLogger() {
        Logger rootLogger = Logger.getLogger("");
        ConsoleHandler parentHandler = new ConsoleHandler();
        rootLogger.addHandler(parentHandler);
        Logger logger = Logger.getLogger("myChildLogger0");
        Assert.assertTrue((boolean)LoggerHelper.getHandlersOrParentHanders((Logger)logger).contains(parentHandler));
    }

    @Test
    public void testGetHandlersOrParentHanderslOnALogger() {
        Logger logger = Logger.getLogger("myChildLogger0");
        ConsoleHandler parentHandler = new ConsoleHandler();
        logger.addHandler(parentHandler);
        Assert.assertTrue((boolean)LoggerHelper.getHandlersOrParentHanders((Logger)logger).contains(parentHandler));
    }

    @Test
    public void testGetHandlersOrParentHandersOnLittleChildUserLoggerWithUseParentHandlersToTrue() {
        Logger parentLogger = Logger.getLogger("myParentLogger2");
        ConsoleHandler parentHandler = new ConsoleHandler();
        parentLogger.addHandler(parentHandler);
        Logger littleChildLogger = Logger.getLogger("myParentLogger2.myChildLogger2.myLittleChildLogger2");
        Assert.assertTrue((boolean)LoggerHelper.getHandlersOrParentHanders((Logger)littleChildLogger).contains(parentHandler));
    }

    @Test
    public void testGetHandlersOrParentHandersOnLittleChildUserLoggerWithUseParentHandlersToFalseAndNoHandlerOnChildLogger() {
        Logger parentLogger = Logger.getLogger("myParentLogger2");
        ConsoleHandler parentHandler = new ConsoleHandler();
        parentLogger.addHandler(parentHandler);
        Logger childLogger = Logger.getLogger("myParentLogger2.myChildLogger2");
        childLogger.setUseParentHandlers(false);
        Logger littleChildLogger = Logger.getLogger("myParentLogger2.myChildLogger2.myLittleChildLogger2");
        Assert.assertTrue((!LoggerHelper.getHandlersOrParentHanders((Logger)littleChildLogger).contains(parentHandler) ? 1 : 0) != 0);
    }

    @Test
    public void testGetHandlersOrParentHandersOnLittleChildUserLoggerWithUseParentHandlersToFalseAndAHandlerOnChildLogger() throws Exception {
        Logger parentLogger = Logger.getLogger("myParentLogger2");
        ConsoleHandler parentHandler = new ConsoleHandler();
        parentLogger.addHandler(parentHandler);
        Logger childLogger = Logger.getLogger("myParentLogger2.myChildLogger2");
        childLogger.setUseParentHandlers(false);
        FileHandler childHandler = new FileHandler();
        childLogger.addHandler(childHandler);
        Logger littleChildLogger = Logger.getLogger("myParentLogger2.myChildLogger2.myLittleChildLogger2");
        Assert.assertTrue((boolean)LoggerHelper.getHandlersOrParentHanders((Logger)littleChildLogger).contains(childHandler));
    }
}

