/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger.handler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;

public class TestFileHandler
extends FileHandler {
    private final LinkedList<String> logEntries = new LinkedList();

    public TestFileHandler(String identifier) throws IOException {
        super("%t/" + identifier + "-%u", false);
    }

    public TestFileHandler() throws IOException {
        this("log");
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            String entry = this.getFormatter().format(record);
            if (entry.endsWith("\n")) {
                entry = entry.substring(0, entry.length() - 1);
            }
            this.logEntries.add(entry);
        }
        super.publish(record);
    }

    public LinkedList<String> getLogEntries() {
        return (LinkedList)this.logEntries.clone();
    }

    @Override
    public void close() throws SecurityException {
        this.logEntries.clear();
        super.close();
    }
}

