/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger.handler;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.logger.LogDataFormatter;
import com.ebmwebsourcing.easycommons.logger.LogRecordHelper;
import com.ebmwebsourcing.easycommons.logger.handler.ContextualFileHandler;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.thread.TestThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContextualFileHandlerTest {
    @Before
    public void before() {
        LogManager.getLogManager().reset();
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testConfigurationWithAllPropertiesSet() throws Exception {
        LogManager manager = LogManager.getLogManager();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("logConf.properties");
        manager.readConfiguration(is);
        ContextualFileHandler cfh = new ContextualFileHandler();
        Assert.assertSame((Object)Level.FINEST, (Object)cfh.getLevel());
        Assert.assertEquals((Object)"my/test/basedir", (Object)cfh.getBasedir());
        Assert.assertEquals((Object)"my/test/subdir", (Object)cfh.getSubdir());
        Assert.assertEquals((Object)"myTestLogFilename", (Object)cfh.getLogFilename());
        Assert.assertEquals(LogDataFormatter.class, cfh.getFormatter().getClass());
    }

    @Test
    public void testDefaultConfiguration() throws Exception {
        ContextualFileHandler cfh = new ContextualFileHandler();
        Assert.assertSame((Object)Level.INFO, (Object)cfh.getLevel());
        Assert.assertEquals((Object)System.getProperty("user.dir"), (Object)cfh.getBasedir());
        Assert.assertEquals((Object)"", (Object)cfh.getSubdir());
        Assert.assertEquals((Object)"default.log", (Object)cfh.getLogFilename());
        Assert.assertEquals(SimpleFormatter.class, cfh.getFormatter().getClass());
    }

    @Test(expected=UncheckedException.class)
    public void testConstructionWithEmptyLogFilename() throws Exception {
        new ContextualFileHandler("baseDirTest", "subDirTest", "", new Properties());
    }

    @Test(expected=UncheckedException.class)
    public void testConstructionWithFileSeparatorInLogFilename() throws Exception {
        new ContextualFileHandler("baseDirTest", "subDirTest", "test/Filename", new Properties());
    }

    @Test(expected=UncheckedException.class)
    public void testConstructionWithLoopPropertyInBasedir() throws Exception {
        Properties properties = new Properties();
        properties.put("test.loop1", "testBaseDir/${test.loop1}");
        new ContextualFileHandler("baseDirTest/${test.loop1}", "subDirTest", "logFileTest", properties);
    }

    @Test
    public void testConstructionWithResolvablePropertyInBasedir() throws Exception {
        Properties properties = new Properties();
        properties.put("test.resolvable", "testBaseDirValue");
        ContextualFileHandler cfh = new ContextualFileHandler("baseDirTest/${test.resolvable}", "subDirTest", "logFileTest", properties);
        Assert.assertEquals((Object)"baseDirTest/testBaseDirValue", (Object)cfh.getBasedir());
    }

    @Test
    public void testConstructionWithUnresolvedPropertyInBasedir() throws Exception {
        ContextualFileHandler cfh = new ContextualFileHandler("baseDirTest/${unresolved_property}", "subDirTest", "logFileTest", new Properties());
        Assert.assertEquals((Object)"baseDirTest/${unresolved_property}", (Object)cfh.getBasedir());
    }

    private static final void compareLogRecordsWithFormattedLogRecords(List<LogRecord> expectedLogRecords, List<String> formattedLogRecords) {
        Object[] expectedFormattedLogRecords = new String[expectedLogRecords.size()];
        SimpleFormatter sf = new SimpleFormatter();
        for (int i = 0; i < expectedLogRecords.size(); ++i) {
            expectedFormattedLogRecords[i] = sf.format(expectedLogRecords.get(i));
        }
        Assert.assertArrayEquals((Object[])expectedFormattedLogRecords, (Object[])formattedLogRecords.toArray(new String[formattedLogRecords.size()]));
    }

    private static final List<LogRecord> createTestLogRecords(String[] logMessages) {
        ArrayList<LogRecord> expectedLogRecords = new ArrayList<LogRecord>();
        for (String logMessage : logMessages) {
            LogRecord lr = LogRecordHelper.newLogRecord(Level.SEVERE, logMessage, 0L);
            expectedLogRecords.add(lr);
        }
        return Collections.unmodifiableList(expectedLogRecords);
    }

    private static final void testPublishRecords(ContextualFileHandler cfh, List<LogRecord> logRecordsToPublish, File expectedOutputFile, List<LogRecord> expectedLogRecords) throws IOException {
        for (LogRecord lr : logRecordsToPublish) {
            cfh.publish(lr);
        }
        ContextualFileHandlerTest.compareLogRecordsWithFormattedLogRecords(expectedLogRecords, ContextualFileHandlerTest.parseFormattedRecords(expectedOutputFile));
    }

    @Test
    public void testPublishWithUnresolvedPropertyInSubdir() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        ContextualFileHandler cfh = new ContextualFileHandler(basedir.getAbsolutePath(), "subDirTest/${unresolved_property}", "logFileTest", new Properties());
        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}), new File(basedir, "subDirTest/${unresolved_property}/logFileTest"), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}));
    }

    @Test
    public void testPublishWithUnresolvedPropertyInLogFilename() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        ContextualFileHandler cfh = new ContextualFileHandler(basedir.getAbsolutePath(), "subDirTest/testDir", "${unresolved_property}", new Properties());
        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}), new File(basedir, "subDirTest/testDir/${unresolved_property}"), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}));
    }

    @Test
    public void testPublishButInvalidLogFilePath() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        String subdir = "subDirTest/dirTest";
        String logFilename = "testlogFileName";
        this.testPublishWithReportedError(basedir, subdir, logFilename);
    }

    private void testPublishWithReportedError(File basedir, String subdir, String logFilename) {
        File alreadyExistingDir = new File(basedir, subdir + File.separator + logFilename);
        alreadyExistingDir.mkdirs();
        ContextualFileHandler cfh = new ContextualFileHandler(basedir.getAbsolutePath(), subdir, logFilename, new Properties());
        LogRecord lr = new LogRecord(Level.SEVERE, "testMessage1");
        final ArrayList reportedErrors = new ArrayList();
        cfh.setErrorManager(new ErrorManager(){

            @Override
            public synchronized void error(String msg, Exception ex, int code) {
                reportedErrors.add(msg);
            }
        });
        cfh.publish(lr);
        Assert.assertEquals((long)1L, (long)reportedErrors.size());
    }

    @Test
    public void testPublishWithLoopPropertyInSubdir() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        String subdir = "subDirTest/${test.loop1}";
        String logFilename = "testlogFileName";
        ExecutionContext.getProperties().setProperty("test.loop1", "testBaseDir/${test.loop1}");
        this.testPublishWithReportedError(basedir, subdir, logFilename);
    }

    @Test
    public void testPublishWithLoopPropertyInFilename() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        String subdir = "subDirTest/testSubDir";
        String logFilename = "test${test.loop1}";
        ExecutionContext.getProperties().setProperty("test.loop1", "testBaseDir/${test.loop1}");
        this.testPublishWithReportedError(basedir, subdir, logFilename);
    }

    @Test
    public void testPublishCreatesLogFileIfAbsent() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        String subdir = "subDirTest/testSubDir";
        String logFilename = "testlogFileName";
        ContextualFileHandler cfh = new ContextualFileHandler(basedir.getAbsolutePath(), subdir, logFilename, new Properties());
        File logFile = new File(basedir, subdir + File.separator + logFilename);
        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}), new File(basedir, subdir + File.separator + logFilename), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}));
        Assert.assertTrue((boolean)logFile.delete());
        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage2", "testMessage3"}), new File(basedir, subdir + File.separator + logFilename), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage2", "testMessage3"}));
    }

    @Test
    public void testPublishAppendsInLogFileIfPresentBetweenTwoRuns() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        String subdir = "subDirTest/testSubDir";
        String logFilename = "testlogFileName";
        ContextualFileHandler cfh1 = new ContextualFileHandler(basedir.getAbsolutePath(), subdir, logFilename, new Properties());
        ContextualFileHandlerTest.testPublishRecords(cfh1, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}), new File(basedir, subdir + File.separator + logFilename), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}));
        ContextualFileHandler cfh2 = new ContextualFileHandler(basedir.getAbsolutePath(), subdir, logFilename, new Properties());
        ContextualFileHandlerTest.testPublishRecords(cfh2, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage2", "testMessage3"}), new File(basedir, subdir + File.separator + logFilename), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1", "testMessage2", "testMessage3"}));
    }

    @Test
    public void testPublishAppendsInLogFileIfPresent() throws Exception {
        File tempdir = FileSystemHelper.createTempDir();
        File basedir = new File(tempdir, "baseDirTest/dirTest");
        String subdir = "subDirTest/testSubDir";
        String logFilename = "testlogFileName";
        ContextualFileHandler cfh = new ContextualFileHandler(basedir.getAbsolutePath(), subdir, logFilename, new Properties());
        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}), new File(basedir, subdir + File.separator + logFilename), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1"}));
        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage2", "testMessage3"}), new File(basedir, subdir + File.separator + logFilename), ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessage1", "testMessage2", "testMessage3"}));
    }

    @Test
    public void testPublishOnSeveralDifferentFilesConcurrently() throws Exception {
        int i;
        File tempdir = FileSystemHelper.createTempDir();
        final File basedir = new File(tempdir, "baseDirTest/dirTest");
        final ContextualFileHandler cfh = new ContextualFileHandler(basedir.getAbsolutePath(), "${subDirTest}/testDir", "testlogFileName", new Properties());
        int nbThreads = 100;
        final CyclicBarrier barrier = new CyclicBarrier(100);
        TestThread[] testThreads = new TestThread[100];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new TestThread(new Runnable(){

                @Override
                public void run() {
                    String threadId = String.valueOf(Thread.currentThread().getId());
                    try {
                        barrier.await();
                    }
                    catch (InterruptedException ie) {
                        throw new UncheckedException((Throwable)ie);
                    }
                    catch (BrokenBarrierException bbe) {
                        throw new UncheckedException((Throwable)bbe);
                    }
                    ExecutionContext.getProperties().setProperty("subDirTest", threadId);
                    File expectedOutputFile = new File(basedir, threadId + "/testDir/testlogFileName");
                    try {
                        ContextualFileHandlerTest.testPublishRecords(cfh, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessageA" + threadId, "testMessageB" + threadId, "testMessageC" + threadId}), expectedOutputFile, ContextualFileHandlerTest.createTestLogRecords(new String[]{"testMessageA" + threadId, "testMessageB" + threadId, "testMessageC" + threadId}));
                    }
                    catch (IOException ioe) {
                        throw new UncheckedException((Throwable)ioe);
                    }
                }
            });
            testThreads[i].start();
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].joinExplosively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> parseFormattedRecords(File file) throws IOException {
        assert (file != null);
        ArrayList<String> records = new ArrayList<String>();
        String strLine = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            strLine = br.readLine();
            while (strLine != null) {
                String record = strLine + '\n';
                strLine = br.readLine();
                assert (strLine != null) : "A log record formatted by a java.util.logging.SimpleFormatter takes 2 lines.";
                record = record + strLine + '\n';
                records.add(record);
                strLine = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return Collections.unmodifiableList(records);
    }
}

