
package com.ebmwebsourcing.easycommons.logger;

import java.lang.reflect.Array;
import java.util.Map;

public class BasicLogDataAppender implements LogDataAppender {

    @Override
    public boolean canAppend(Map<String,Object> logData, String dataKey) {
        assert logData != null;
        assert dataKey != null;
        return true;
    }

    @Override
    public void append(StringBuffer outBuffer, Map<String,Object> logData, String dataKey) {
        outBuffer.append(dataKey);
        Object dataValue = logData.get(dataKey);
        outBuffer.append(" = ");
        if (dataValue == null) {
            outBuffer.append("null");
        } else if (dataValue.getClass().isArray()) {
            outBuffer.append("'");
            int len = Array.getLength(dataValue);
            for (int i = 0; i < len; ++i) {
                outBuffer.append(String.valueOf(Array.get(dataValue, i)));
                if (i != len - 1)
                    outBuffer.append(", ");
            }
            outBuffer.append("'");
        } else {
            outBuffer.append("'").append(String.valueOf(dataValue)).append("'");
        }
    }
}
