
package com.ebmwebsourcing.easycommons.logger;

/**
 * Class allowing to define specific <Level> in addition to JDK logging levels.
 * 
 * @author mjambert, aruffie
 * 
 */
public final class Level extends java.util.logging.Level {

    private static final long serialVersionUID = -5961140360420071107L;

    public static final java.util.logging.Level MONIT = new Level("MONIT", 600);

    public static final java.util.logging.Level MONIT_MSG = new Level("MONIT-MSG", 550);

    protected Level(String name, int value) {
        super(name, value);
    }

    /**
     * Allow to return all JDK logging <Level> and specific logging <Level>.
     * 
     * @return All <Level> as an array in decreasing order.
     */
    public static final java.util.logging.Level[] getLevels() {
        return new java.util.logging.Level[] { OFF, SEVERE, WARNING, INFO, CONFIG, MONIT, MONIT_MSG, FINE,
                FINER, FINEST, ALL };
    }

    /**
     * This empty method must be called before any use of a custom Level. Custom
     * Level constructor add custom Levels to known Levels registered in
     * {@link java.util.logging.Level} class.
     */
    public static void initialize() {
    }

}
