/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.properties;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesHelper {
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final String PLACE_HOLDER_BEGIN_PATTERN = "\\$\\{";
    private static final String PLACE_HOLDER_END_PATTERN = "\\}";
    private static final String PLACE_HOLDER_BEGIN = "${";
    private static final String PLACE_HOLDER_END = "}";

    public static final void resolveProperties(Properties propertiesToResolve, Properties propertiesToUse) throws PropertiesException {
        Set<String> propertyNames = propertiesToResolve.stringPropertyNames();
        Properties propertiesToUseToResolve = new Properties();
        propertiesToUseToResolve.putAll((Map<?, ?>)propertiesToUse);
        propertiesToUseToResolve.putAll((Map<?, ?>)propertiesToResolve);
        Properties resolvedProperties = new Properties();
        for (String propertyName : propertyNames) {
            ArrayList<String> parentPropertyNames = new ArrayList<String>();
            String propertyValue = PropertiesHelper.resolveProperty(propertiesToUseToResolve, propertyName, resolvedProperties, parentPropertyNames);
            propertiesToResolve.put(propertyName, propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ByteArrayInputStream resolvePropertiesForInputStream(InputStream inputStreamToResolve, Properties propertiesToUse) throws PropertiesException, IOException {
        assert (inputStreamToResolve != null);
        ByteArrayInputStream resultInputStream = null;
        ByteArrayOutputStream out = null;
        try {
            Properties propertiesToResolve = new Properties();
            propertiesToResolve.load(inputStreamToResolve);
            PropertiesHelper.resolveProperties(propertiesToResolve, propertiesToUse);
            out = new ByteArrayOutputStream();
            propertiesToResolve.store(out, "");
            resultInputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close((Closeable)out);
        return resultInputStream;
    }

    public static final void resolveMapWithNoException(Map<String, String> mapToResolve, Properties propertiesToUse) {
        Iterator<String> keys = mapToResolve.keySet().iterator();
        Properties resolvedProperties = new Properties();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = mapToResolve.get(key);
            try {
                value = PropertiesHelper.resolveString(value, propertiesToUse, resolvedProperties);
            }
            catch (PropertiesException pe) {
                // empty catch block
            }
            mapToResolve.put(key, value);
        }
    }

    public static final void resolveMap(Map<String, String> mapToResolve, Properties propertiesToUse) throws PropertiesException {
        Iterator<String> keys = mapToResolve.keySet().iterator();
        Properties resolvedProperties = new Properties();
        while (keys.hasNext()) {
            String key = keys.next();
            String value = mapToResolve.get(key);
            value = PropertiesHelper.resolveString(value, propertiesToUse, resolvedProperties);
            mapToResolve.put(key, value);
        }
    }

    public static final String resolveString(String str, Properties propertiesToUse) throws PropertiesException {
        Properties resolvedProperties = new Properties();
        return PropertiesHelper.resolveString(str, propertiesToUse, resolvedProperties);
    }

    public static final boolean containsPlaceHolder(String str) {
        Matcher matcher = PLACE_HOLDER_PATTERN.matcher(str);
        return matcher.find();
    }

    private static final String resolveString(String str, Properties propertiesToUse, Properties resolvedProperties) throws PropertiesException {
        Matcher matcher = PLACE_HOLDER_PATTERN.matcher(str);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            ArrayList<String> parentPropertyNames = new ArrayList<String>();
            String propertyValue = PropertiesHelper.resolveProperty(propertiesToUse, propertyName, resolvedProperties, parentPropertyNames);
            str = str.replaceAll(PLACE_HOLDER_BEGIN_PATTERN + propertyName + PLACE_HOLDER_END_PATTERN, Matcher.quoteReplacement(propertyValue));
        }
        return str;
    }

    private static final String resolveProperty(Properties propertiesToUse, String propertyName, Properties resolvedProperties, List<String> parentPropertyNames) throws PropertiesException {
        String propertyValue;
        if (resolvedProperties.containsKey(propertyName)) {
            propertyValue = resolvedProperties.getProperty(propertyName);
        } else {
            propertyValue = propertiesToUse.getProperty(propertyName);
            if (propertyValue != null) {
                Matcher matcher = PLACE_HOLDER_PATTERN.matcher(propertyValue);
                if (matcher.find()) {
                    ArrayList<String> alreadyReplacedProperties = new ArrayList<String>();
                    do {
                        String subPropertyName;
                        if (parentPropertyNames.contains(subPropertyName = matcher.group(1))) {
                            throw new PropertiesException("There is a place holder loop in the specified properties");
                        }
                        if (alreadyReplacedProperties.contains(subPropertyName)) continue;
                        parentPropertyNames.add(subPropertyName);
                        String subPropertyValue = PropertiesHelper.resolveProperty(propertiesToUse, subPropertyName, resolvedProperties, parentPropertyNames);
                        parentPropertyNames.remove(subPropertyName);
                        propertyValue = propertyValue.replaceAll(PLACE_HOLDER_BEGIN_PATTERN + subPropertyName + PLACE_HOLDER_END_PATTERN, Matcher.quoteReplacement(subPropertyValue));
                        alreadyReplacedProperties.add(subPropertyName);
                    } while (matcher.find());
                    resolvedProperties.put(propertyName, propertyValue);
                }
            } else {
                propertyValue = PLACE_HOLDER_BEGIN + propertyName + PLACE_HOLDER_END;
                resolvedProperties.put(propertyName, propertyValue);
            }
        }
        return propertyValue;
    }

    public static final Properties flattenProperties(Properties properties) {
        assert (properties != null);
        Properties flattenProperties = new Properties();
        for (Object propertyName : Collections.list(properties.propertyNames())) {
            assert (propertyName instanceof String);
            flattenProperties.put((String)propertyName, properties.getProperty((String)propertyName));
        }
        return flattenProperties;
    }

    public static String[] parsePropertyValues(String propValue) {
        assert (propValue != null);
        propValue = propValue.trim();
        int idx = 0;
        Vector<String> result = new Vector<String>();
        while (idx < propValue.length()) {
            int end;
            for (end = idx; end < propValue.length() && !Character.isWhitespace(propValue.charAt(end)) && propValue.charAt(end) != ','; ++end) {
            }
            String word = propValue.substring(idx, end);
            idx = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }
}

