package com.ebmwebsourcing.easycommons.sca.helper.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.types.Step;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;

@Scope("COMPOSITE")
@Service(value=SCAComponent.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class SCAComponentImpl implements SCAComponent {

	private static Logger log = Logger.getLogger(SCAComponentImpl.class.getName());
	
	/**
	 * The Frascati scope component
	 */
    @Controller
	private Component component = null;
    
	
    /**
     * Create the component
     */
    @Lifecycle(step = Step.CREATE)
    public void createSCAComponent() throws SCAException {
    	SCAComponentImpl.log.fine("Fractal component created: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    /**
     * Start the component
     */
    @Lifecycle(step = Step.START)
    public void startSCAComponent() throws SCAException {
    	SCAComponentImpl.log.fine("Fractal component started: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    /**
     * Stop the component
     */
    @Lifecycle(step = Step.STOP)
    public void stopSCAComponent() throws SCAException {
    	SCAComponentImpl.log.fine("Fractal component stopped: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    @Lifecycle(step = Step.DESTROY)
    public void destroySCAComponent() throws SCAException {
    	SCAComponentImpl.log.fine("Fractal component destroyed: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }


    public Component getComponent() {
		return component;
	}


    public String getName()  {
    	String name = null;
        try {
			name = SCAHelper.getSCAHelper().getName(this.getComponent());
		} catch (SCAException e) {
			// do nothing
		}
		return name;
    }

    public void setName(String name) {
        try {
			SCAHelper.getSCAHelper().changeName(this.getComponent(), name);
		} catch (SCAException e) {
			// do nothing
		}
    }

	
	@Override
	public String toString(){
	   
	    return "SCAComponent "+this.getName();
	}
}
