/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import java.util.List;

import org.objectweb.fractal.api.Component;
import org.ow2.frascati.tinfi.TinfiDomain;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCAIntentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;


public class SCAIntentHelper {

	private static SCAIntentHelper intentHelper = new SCAIntentHelper();


	private SCAIntentHelper(){
		super();
	}

	public static SCAIntentHelper getSCAIntentHelper(){
		return SCAIntentHelper.intentHelper;
	}

	
	
	public void injectIntentIntoComponents(String intenthandler, List<Component> comps) throws SCAException{
		for(Component comp : comps){
			injectIntentIntoComponent(intenthandler, comp);
		}
	}
	
	public void injectIntentIntoComponent(String intenthandler, Component comp) throws SCAException{

		String adl = intenthandler+"Factory";

		try {
			IntentHandler intent = TinfiDomain.getService(adl, IntentHandler.class,"service");
			SCAIntentController ic = (SCAIntentController) comp.getFcInterface(SCAIntentController.NAME);

			boolean wasStarted = false;
			if(SCAHelper.getSCAHelper().isStarted(comp)){
				SCAHelper.getSCAHelper().stopComponent(comp);
				wasStarted = true;
			}

			ic.addFcIntentHandler(intent);


			if(wasStarted){
				SCAHelper.getSCAHelper().startComponent(comp);
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new SCAException(e.getMessage());
		}		
	}

	
	
	public void releaseIntentInComponents(IntentHandler intent, List<Component> comps) throws SCAException{
		
		for(Component comp : comps){
			releaseIntentInComponent(intent, comp);
		}
	}
	
	
	public void releaseIntentInComponent(IntentHandler intent, Component comp) throws SCAException{

		SCAIntentController ic;
		try {
			ic = (SCAIntentController) comp.getFcInterface(SCAIntentController.NAME);


			boolean wasStarted = false;
			if(SCAHelper.getSCAHelper().isStarted(comp)){
				SCAHelper.getSCAHelper().stopComponent(comp);
				wasStarted = true;
			}

			ic.removeFcIntentHandler(intent);


			if(wasStarted){
				SCAHelper.getSCAHelper().startComponent(comp);
			}

		} catch (Exception e){
			e.printStackTrace();
			throw new SCAException(e.getMessage());
		}
	}
}