/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/

package com.ebmwebsourcing.easycommons.sca.helper.impl;

import java.io.IOException;

import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.api.JuliacModuleItf;
import org.objectweb.fractal.juliac.api.MembraneLoaderItf; 
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.conf.JulietLoader;


/**
 * <p>
 * This class is a temporary replacement for the EasyCommons SCA Implementation
 * module to be used by the frascati-implementation-bpel module. The original
 * SCAEasy class was developed for Tinfi 1.4.4. When updgrading from Tinfi
 * 1.4.4 to 1.4.5 in FraSCAti, this class and its module will replace the
 * original ones, until a new version of EasyBPEL, and by transitivity
 * EasyCommons, is released.
 * </p>
 *
 * <p>
 * This class is deprecated to stress the fact that this is a temporary solution
 * not to be used outside of the context mentioned previously.
 * </p>
 *
 * @author Lionel Seinturier <Lionel.Seinturier@univ-lille1.fr>
 * @since 1.4.5
 */
@Deprecated
public class SCAEasy implements JuliacModuleItf { 

	public void init( Juliac jc ) throws IOException { 
		JuliacConfig jconf = jc.getJuliacConfig();
		MembraneLoaderItf mloader = jconf.loadModuleIfNew(JulietLoader.class.getName(), JulietLoader.class ); 

		mloader.put( SCAEasyPrimitive.NAME, SCAEasyPrimitive.class );
		mloader.put(
				SCAEasyCompositeWithContent.NAME,
				SCAEasyCompositeWithContent.class );
	} 


	public void close( Juliac jc ) throws IOException {

	} 
}
