/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.ow2.frascati.tinfi.TinfiDomain;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCAIntentController;

public class SCAIntentHelper {
    private static SCAIntentHelper intentHelper = new SCAIntentHelper();

    private SCAIntentHelper() {
    }

    public static SCAIntentHelper getSCAIntentHelper() {
        return intentHelper;
    }

    public void injectIntentIntoComponents(String intenthandler, List<Component> comps) throws SCAException {
        for (Component comp : comps) {
            this.injectIntentIntoComponent(intenthandler, comp);
        }
    }

    public void injectIntentIntoComponent(String intenthandler, Component comp) throws SCAException {
        String adl = String.valueOf(intenthandler) + "Factory";
        try {
            IntentHandler intent = (IntentHandler)TinfiDomain.getService((String)adl, IntentHandler.class, (String)"service");
            SCAIntentController ic = (SCAIntentController)comp.getFcInterface("sca-intent-controller");
            boolean wasStarted = false;
            if (SCAHelper.getSCAHelper().isStarted(comp)) {
                SCAHelper.getSCAHelper().stopComponent(comp);
                wasStarted = true;
            }
            ic.addFcIntentHandler(intent);
            if (wasStarted) {
                SCAHelper.getSCAHelper().startComponent(comp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SCAException(e.getMessage());
        }
    }

    public void releaseIntentInComponents(IntentHandler intent, List<Component> comps) throws SCAException {
        for (Component comp : comps) {
            this.releaseIntentInComponent(intent, comp);
        }
    }

    public void releaseIntentInComponent(IntentHandler intent, Component comp) throws SCAException {
        try {
            SCAIntentController ic = (SCAIntentController)comp.getFcInterface("sca-intent-controller");
            boolean wasStarted = false;
            if (SCAHelper.getSCAHelper().isStarted(comp)) {
                SCAHelper.getSCAHelper().stopComponent(comp);
                wasStarted = true;
            }
            ic.removeFcIntentHandler(intent);
            if (wasStarted) {
                SCAHelper.getSCAHelper().startComponent(comp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SCAException(e.getMessage());
        }
    }
}

