/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamForker {
    private static final int BUFFER_SIZE = 8192;
    private final byte[] bytes;

    public InputStreamForker(InputStream originalInputStream) {
        this.bytes = InputStreamForker.readBytes(new BufferedInputStream(originalInputStream));
    }

    private static final byte[] readBytes(InputStream originalInputStream) {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = originalInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
        return baos.toByteArray();
    }

    public final InputStream fork() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }
}

