
package com.ebmwebsourcing.easycommons.thread;

public final class InheritableThreadContext {

    private static InheritableThreadLocal<ConcurrentHashMapWithDefaults<String, Object>> itl;

    static {
        reset();
    }

    private InheritableThreadContext() {
    }

    public static final void reset() {
        itl = new InheritableThreadLocal<ConcurrentHashMapWithDefaults<String, Object>>() {
            @Override
            protected ConcurrentHashMapWithDefaults<String, Object> initialValue() {
                return new ConcurrentHashMapWithDefaults<String, Object>();
            }

            @Override
            protected ConcurrentHashMapWithDefaults<String, Object> childValue(
                    ConcurrentHashMapWithDefaults<String, Object> parentValue) {
                ConcurrentHashMapWithDefaults<String, Object> childValue = new ConcurrentHashMapWithDefaults<String, Object>(
                        parentValue);
                return childValue;
            }
        };
    }

    public static final ConcurrentHashMapWithDefaults<String, Object> getParameters() {
        return itl.get();
    }

}
