/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;

public final class LabelledParameterized
extends Parameterized {
    private List<String> labels;
    private Description labelledDescription;

    public LabelledParameterized(Class<?> cl) throws Throwable {
        super(cl);
        this.initialiseLabels();
        this.generateLabelledDescription();
    }

    private void initialiseLabels() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameterized.Parameters.class);
        if (methods.size() != 1) {
            throw new Exception("One method should be annotated with @Parameters.");
        }
        FrameworkMethod parametersMethod = (FrameworkMethod)methods.get(0);
        Collection parameterArrays = (Collection)parametersMethod.getMethod().invoke(null, new Object[0]);
        this.labels = new ArrayList<String>();
        for (Object[] parameterArray : parameterArrays) {
            String label = parameterArray[0].toString();
            this.labels.add(label);
        }
    }

    private void generateLabelledDescription() throws Exception {
        Description originalDescription = super.getDescription();
        this.labelledDescription = Description.createSuiteDescription((String)originalDescription.getDisplayName(), (Annotation[])new Annotation[0]);
        ArrayList childDescriptions = originalDescription.getChildren();
        int childCount = childDescriptions.size();
        if (childCount != this.labels.size()) {
            throw new Exception("Number of labels and number of parameters must match.");
        }
        for (int i = 0; i < childDescriptions.size(); ++i) {
            Description childDescription = (Description)childDescriptions.get(i);
            String label = this.labels.get(i);
            Description newDescription = Description.createSuiteDescription((String)label, (Annotation[])new Annotation[0]);
            ArrayList grandChildren = childDescription.getChildren();
            for (Description grandChild : grandChildren) {
                newDescription.addChild(grandChild);
            }
            this.labelledDescription.addChild(newDescription);
        }
    }

    public Description getDescription() {
        return this.labelledDescription;
    }
}

