/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class XMLComparatorTest {
    public static Logger log = Logger.getLogger(XMLComparatorTest.class.getName());

    private static final void assertCommutativeEquivalence(boolean isEquivalent, String operand1, String operand2) {
        Assert.assertEquals((Object)isEquivalent, (Object)XMLComparator.isEquivalent((String)operand1, (String)operand2));
        Assert.assertEquals((Object)isEquivalent, (Object)XMLComparator.isEquivalent((String)operand2, (String)operand1));
    }

    @Test
    public void testIsEquivalent0() throws Exception {
        String xml1 = "<a/>";
        String xml2 = "<a></a>";
        XMLComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent1() throws Exception {
        String xml1 = "<a xmlns:pf1='http://ns1'/>";
        String xml2 = "<a></a>";
        XMLComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent2() throws Exception {
        String xml1 = "<a att1='value'/>";
        String xml2 = "<a></a>";
        XMLComparatorTest.assertCommutativeEquivalence(false, xml1, xml2);
    }

    @Test
    public void testIsEquivalent3() throws Exception {
        String xml1 = "<getBusinessMessage xmlns='http://petals.ow2.org/FaultWS/'><in xmlns='' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:type='xsd:string'>0</in></getBusinessMessage>";
        String xml2 = "<tns:getBusinessMessage xmlns:tns='http://petals.ow2.org/FaultWS/'>  <in xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:type='xsd:string'>0</in></tns:getBusinessMessage>";
        XMLComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent4() throws Exception {
        String xml1 = "<a att1='value' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:type='TOTO'/>";
        String xml2 = "<a att1='value'></a>";
        XMLComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent5() throws Exception {
        String xml1 = "<a att1='value'/>";
        String xml2 = "<a att1='value' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:type='TOTO'></a>";
        XMLComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent6() throws Exception {
        String xml1 = "<a att1='value' toto='tutu'/>";
        String xml2 = "<a att1='value' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:type='TOTO'></a>";
        XMLComparatorTest.assertCommutativeEquivalence(false, xml1, xml2);
    }
}

