/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHelperTest {
    @Test
    public void testCreateStringFromNodeList() throws Exception {
        String message = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body><customElt>[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload</customElt></ns0:body></ns0:mail>";
        String expected = "<customElt xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\">[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload</customElt>";
        Document doc = XMLHelperTest.createDOMDocumentFromMessage(message);
        String result = XMLHelper.toString((NodeList)XMLHelperTest.findBodyNode(doc).getChildNodes());
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expected, (String)result));
    }

    @Test
    public void testCreateStringFromNodeListWithIllegalXmlCharEscaped() throws Exception {
        String message = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body>&lt;customElt&gt;[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload&lt;/customElt&gt;</ns0:body></ns0:mail>";
        String expected = "<customElt>[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload</customElt>";
        Document doc = XMLHelperTest.createDOMDocumentFromMessage(message);
        String result = XMLHelper.toString((NodeList)XMLHelperTest.findBodyNode(doc).getChildNodes());
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expected, (String)result));
    }

    @Test
    public void testCreateStringFromNodeListWithCDATA() throws Exception {
        String message = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body><![CDATA[<customElt>[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload</customElt>]]></ns0:body></ns0:mail>";
        String expected = "<customElt>[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload</customElt>";
        Document doc = XMLHelperTest.createDOMDocumentFromMessage(message);
        String result = XMLHelper.toString((NodeList)XMLHelperTest.findBodyNode(doc).getChildNodes());
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expected, (String)result));
    }

    @Test
    public void testCreateStringFromDOMDocument() throws Exception {
        String message = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body><![CDATA[<customElt>[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload</customElt>]]></ns0:body></ns0:mail>";
        Document doc = XMLHelperTest.createDOMDocumentFromMessage(message);
        String result = XMLHelper.createStringFromDOMDocument((Node)doc);
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)message, (String)result));
        Assert.assertTrue((boolean)result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
    }

    @Test
    public void testCreateStringFromDOMNode() throws Exception {
        String message = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body>&lt;customElt&gt;[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload&lt;/customElt&gt;</ns0:body></ns0:mail>";
        String expected = "<ns0:body xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\">&lt;customElt&gt;[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload&lt;/customElt&gt;</ns0:body>";
        Document doc = XMLHelperTest.createDOMDocumentFromMessage(message);
        String result = XMLHelper.createStringFromDOMNode((Node)XMLHelperTest.findBodyNode(doc));
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expected, (String)result));
        Assert.assertTrue((!result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") ? 1 : 0) != 0);
    }

    @Test
    public void testWriteDocument() throws Exception {
        String message = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body>&lt;customElt&gt;[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload&lt;/customElt&gt;</ns0:body></ns0:mail>";
        Document doc = XMLHelperTest.createDOMDocumentFromMessage(message);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLHelper.writeDocument((Document)doc, (OutputStream)baos);
        String result = new String(baos.toByteArray());
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)message, (String)result));
        Assert.assertTrue((boolean)result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateDocumentFromString() throws Exception {
        String xml = "<ns0:mail xmlns:ns0=\"http://petals.ow2.org/components/mail/version-3\"><ns0:host>192.168.1.206</ns0:host><ns0:from>user2@devmail.com</ns0:from><ns0:reply>user2@devmail.com</ns0:reply><ns0:to>user2@devmail.com</ns0:to><ns0:subject>Integration mail test(GenericService). MESSAGE TYPE: XML</ns0:subject><ns0:body>&lt;customElt&gt;[#IMAP-PAYLOAD-XML]Sending mail with addressing in the message payload&lt;/customElt&gt;</ns0:body></ns0:mail>";
        Document document = XMLHelper.createDocumentFromString((String)xml);
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(source, result);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)xml, (String)writer.toString()));
    }

    @Test
    public void testFindChildRecursiveFound() throws Exception {
        String xml = "<test:directory xmlns:test=\"http://petals.ow2.org/test/\"><test:person><test:name>dupont</test:name><test:firstName>roger</test:firstName><test:address><test:street>rue de la fontaine</test:street><test:town>Marseille</test:town></test:address></test:person><test:person><test:name>durand</test:name><test:firstName>bernard</test:firstName><test:address><test:street>route de Paris</test:street><test:town>Lyon</test:town></test:address></test:person><test:person><test:name>dupond</test:name><test:firstName>jean</test:firstName><test:address><test:street>rue de l'URSS</test:street><test:town>Lille</test:town></test:address></test:person></test:directory>";
        Document document = XMLHelper.createDocumentFromString((String)xml);
        Node node = XMLHelper.findChild((Node)document, (String)"http://petals.ow2.org/test/", (String)"street", (boolean)true);
        Assert.assertTrue((node != null ? 1 : 0) != 0);
        Assert.assertTrue((node.getNamespaceURI() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node.getNamespaceURI().equals("http://petals.ow2.org/test/"));
        Assert.assertTrue((node.getLocalName() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node.getLocalName().equals("street"));
        Assert.assertTrue((node.getTextContent() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node.getTextContent().equals("rue de la fontaine"));
    }

    @Test
    public void testFindChildRecursiveNotFound() throws Exception {
        String xml = "<test:directory xmlns:test=\"http://petals.ow2.org/test/\"><test:person><test:name>dupont</test:name><test:firstName>roger</test:firstName><test:address><test:street>rue de la fontaine</test:street><test:town>Marseille</test:town></test:address></test:person><test:person><test:name>durand</test:name><test:firstName>bernard</test:firstName><test:address><test:street>route de Paris</test:street><test:town>Lyon</test:town></test:address></test:person><test:person><test:name>dupond</test:name><test:firstName>jean</test:firstName><test:address><test:street>rue de l'URSS</test:street><test:town>Lille</test:town></test:address></test:person></test:directory>";
        Document document = XMLHelper.createDocumentFromString((String)xml);
        Node node = XMLHelper.findChild((Node)document, (String)"http://petals.ow2.org/test/", (String)"stret", (boolean)true);
        Assert.assertTrue((node == null ? 1 : 0) != 0);
    }

    @Test
    public void testFindChildNotRecursiveNotFound() throws Exception {
        String xml = "<test:directory xmlns:test=\"http://petals.ow2.org/test/\"><test:person><test:name>dupont</test:name><test:firstName>roger</test:firstName><test:address><test:street>rue de la fontaine</test:street><test:town>Marseille</test:town></test:address></test:person><test:person><test:name>durand</test:name><test:firstName>bernard</test:firstName><test:address><test:street>route de Paris</test:street><test:town>Lyon</test:town></test:address></test:person><test:person><test:name>dupond</test:name><test:firstName>jean</test:firstName><test:address><test:street>rue de l'URSS</test:street><test:town>Lille</test:town></test:address></test:person></test:directory>";
        Document document = XMLHelper.createDocumentFromString((String)xml);
        Node node = XMLHelper.findChild((Node)document, (String)"http://petals.ow2.org/test/", (String)"street", (boolean)false);
        Assert.assertTrue((node == null ? 1 : 0) != 0);
    }

    @Test
    public void testFindChildNotRecursiveFound() throws Exception {
        String xml = "<test:directory xmlns:test=\"http://petals.ow2.org/test/\"><test:person><test:name>dupont</test:name><test:firstName>roger</test:firstName><test:address><test:street>rue de la fontaine</test:street><test:town>Marseille</test:town></test:address></test:person><test:person><test:name>durand</test:name><test:firstName>bernard</test:firstName><test:address><test:street>route de Paris</test:street><test:town>Lyon</test:town></test:address></test:person><test:person><test:name>dupond</test:name><test:firstName>jean</test:firstName><test:address><test:street>rue de l'URSS</test:street><test:town>Lille</test:town></test:address></test:person></test:directory>";
        Document document = XMLHelper.createDocumentFromString((String)xml);
        Node node = XMLHelper.findChild((Node)document.getDocumentElement(), null, (String)"person", (boolean)false);
        Assert.assertTrue((node != null ? 1 : 0) != 0);
        Assert.assertTrue((node.getNamespaceURI() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node.getNamespaceURI().equals("http://petals.ow2.org/test/"));
        Assert.assertTrue((node.getLocalName() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node.getLocalName().equals("person"));
        Assert.assertTrue((node.getFirstChild() != null ? 1 : 0) != 0);
        Assert.assertTrue((node.getFirstChild().getTextContent() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)node.getFirstChild().getTextContent().equals("dupont"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document createDOMDocumentFromMessage(String message) throws SAXException, IOException {
        DocumentBuilder documentBuilder = null;
        Document doc = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            doc = documentBuilder.parse(new ByteArrayInputStream(message.getBytes()));
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
        }
        return doc;
    }

    private static final Node findBodyNode(Document doc) {
        Element rootElt = doc.getDocumentElement();
        NodeList rootChildNodes = rootElt.getChildNodes();
        for (int i = 0; i < rootChildNodes.getLength(); ++i) {
            String n = rootChildNodes.item(i).getNodeName();
            if (n == null || !n.endsWith("body")) continue;
            return rootChildNodes.item(i);
        }
        return null;
    }
}

