/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.soap;

import com.ebmwebsourcing.easycommons.soap.SoapComparator;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class SoapComparatorTest {
    public static Logger log = Logger.getLogger(SoapComparatorTest.class.getName());

    private static final void assertCommutativeEquivalence(boolean isEquivalent, String operand1, String operand2) {
        Assert.assertEquals((Object)isEquivalent, (Object)SoapComparator.isEquivalent((String)operand1, (String)operand2));
        Assert.assertEquals((Object)isEquivalent, (Object)SoapComparator.isEquivalent((String)operand2, (String)operand1));
    }

    @Test
    public void testIsEquivalent0() throws Exception {
        String xml1 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'><SOAP-ENV:Header/><SOAP-ENV:Body><echoString/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        String xml2 = "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Header/><S:Body><echoString/></S:Body></S:Envelope>";
        SoapComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent1() throws Exception {
        String xml1 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'><SOAP-ENV:Header/><SOAP-ENV:Body><echoString/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        String xml2 = "<S:Envelope xmlns:toto='http://unusednamespacemapping' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Header/><S:Body><echoString/></S:Body></S:Envelope>";
        SoapComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent2() throws Exception {
        String xml1 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'><SOAP-ENV:Header/><SOAP-ENV:Body><echoString/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        String xml2 = "<S:Envelope xmlns:toto='http://unusednamespacemapping' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Body><echoString/></S:Body></S:Envelope>";
        SoapComparatorTest.assertCommutativeEquivalence(true, xml1, xml2);
    }

    @Test
    public void testIsEquivalent3() throws Exception {
        String xml1 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/'><SOAP-ENV:Header/><SOAP-ENV:Body><echoString/></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        String xml2 = "<S:Envelope xmlns:toto='http://unusednamespacemapping' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Header><m:Trans xmlns:m=\"http://www.w3schools.com/transaction/\"\r\n  S:mustUnderstand=\"1\">234\r\n  </m:Trans></S:Header><S:Body><echoString/></S:Body></S:Envelope>";
        SoapComparatorTest.assertCommutativeEquivalence(false, xml1, xml2);
    }

    @Test
    public void testIsEquivalent4() throws Exception {
        String xml1 = "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Header><m:Trans xmlns:m=\"http://www.w3schools.com/transaction/\"\r\n  S:mustUnderstand=\"1\">234\r\n  </m:Trans></S:Header><S:Body><echoString2/></S:Body></S:Envelope>";
        String xml2 = "<S:Envelope xmlns:toto='http://unusednamespacemapping' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><S:Header><m:Trans xmlns:m=\"http://www.w3schools.com/transaction/\"\r\n  S:mustUnderstand=\"1\">234\r\n  </m:Trans></S:Header><S:Body><echoString/></S:Body></S:Envelope>";
        SoapComparatorTest.assertCommutativeEquivalence(false, xml1, xml2);
    }
}

