/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.uri;

import com.ebmwebsourcing.easycommons.uri.URIHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.junit.Test;

public class URIHelperTest {
    @Test
    public void testAllNull() throws MalformedURLException, URISyntaxException {
        Assert.assertNull((Object)URIHelper.resolve(null, null));
    }

    @Test
    public void testBaseUriNull() throws MalformedURLException, URISyntaxException {
        Assert.assertEquals((Object)new URI("crisis.xsd"), (Object)URIHelper.resolve(null, (String)"crisis.xsd"));
    }

    @Test
    public void testFile() throws MalformedURLException, URISyntaxException {
        File f = new File("./petalslink/testParent.xml");
        File expectedChildFile = new File(f.getParent(), "testChild.xml");
        Assert.assertEquals((Object)expectedChildFile.toURI().normalize(), (Object)URIHelper.resolve((URI)f.toURI(), (String)"testChild.xml"));
    }

    @Test
    public void testJar() throws MalformedURLException, URISyntaxException {
        URI jar = new URI("jar:file:/D:/Projects/PetalsLink/test.jar!/fireman.wsdl");
        Assert.assertEquals((String)"jar", (String)jar.getScheme());
        Assert.assertEquals((Object)new URI("jar:file:/D:/Projects/PetalsLink/test.jar!/crisis.xsd"), (Object)URIHelper.resolve((URI)jar, (String)"crisis.xsd"));
    }

    @Test
    public void testHTTP() throws MalformedURLException, URISyntaxException {
        URI http = new URI("http://www.petalsink.org/fireman.wsdl");
        Assert.assertEquals((String)"http", (String)http.getScheme());
        Assert.assertEquals((Object)new URI("http://www.petalsink.org/crisis.xsd"), (Object)URIHelper.resolve((URI)http, (String)"crisis.xsd"));
    }

    @Test
    public void testSpace() throws MalformedURLException, URISyntaxException {
        File f = new File("./petals link/testParent.xml");
        File expectedChildFile = new File(f.getParent(), "testChild.xml");
        Assert.assertEquals((Object)expectedChildFile.toURI().normalize(), (Object)URIHelper.resolve((URI)f.toURI(), (String)"testChild.xml"));
    }
}

