/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.jaxws;

import com.ebmwebsourcing.easycommons.research.util.jaxws.FooService;
import com.ebmwebsourcing.easycommons.research.util.jaxws.HelloService;
import com.ebmwebsourcing.easycommons.research.util.jaxws.HelloServiceImpl;
import com.ebmwebsourcing.easycommons.research.util.jaxws.JAXWSHelper;
import com.ebmwebsourcing.easycommons.research.util.jaxws.NotWebService;
import com.ebmwebsourcing.easycommons.research.util.jaxws.WithNameService;
import junit.framework.TestCase;

public class JAXWSHelperTest
extends TestCase {
    public void testGetWebServiceClass() throws Exception {
        Class clazz = JAXWSHelper.getWebServiceClass(HelloService.class);
        JAXWSHelperTest.assertEquals(HelloService.class, (Object)clazz);
        JAXWSHelperTest.assertNotSame(FooService.class, (Object)clazz);
    }

    public void testGetWebServiceClassFromObject() throws Exception {
        Class clazz = JAXWSHelper.getWebServiceClass(HelloServiceImpl.class);
        JAXWSHelperTest.assertEquals(HelloService.class, (Object)clazz);
        JAXWSHelperTest.assertNotSame(FooService.class, (Object)clazz);
    }

    public void testHasWebServiceAnno() throws Exception {
        JAXWSHelperTest.assertTrue((boolean)JAXWSHelper.hasWebServiceAnnotation(HelloService.class));
        JAXWSHelperTest.assertTrue((boolean)JAXWSHelper.hasWebServiceAnnotation(HelloServiceImpl.class));
        JAXWSHelperTest.assertFalse((boolean)JAXWSHelper.hasWebServiceAnnotation(NotWebService.class));
    }

    public void testGetWebServiceName() throws Exception {
        JAXWSHelperTest.assertEquals((String)HelloService.class.getSimpleName(), (String)JAXWSHelper.getWebServiceName(HelloService.class));
        JAXWSHelperTest.assertEquals((String)"MyServiceName", (String)JAXWSHelper.getWebServiceName(WithNameService.class));
    }
}

