/**
 * 
 */
package com.ebmwebsourcing.easycommons.research.util.cxf;

import javax.xml.namespace.QName;

import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;

import com.ebmwebsourcing.easycommons.research.util.jaxws.JAXWSHelper;

/**
 * @author chamerling
 * 
 */
public class CXFHelper {



	/**
	 * Get a client instance for a given URL. The URL is a final one and is not
	 * built from the JAXWS annotations like in
	 * {@link #getClient(String, Class)}
	 * 
	 * @param <T>
	 * @param fullURL
	 * @param clazz
	 * @return
	 */
	public static <T> T getClient(String fullURL, Class<T> clazz) {
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setAddress(fullURL);
		factory.setServiceClass(clazz);
		Object client = factory.create();
		return clazz.cast(client);
	}

	public static <T> Server getService(String baseURL, Class<T> clazz, Object bean) {
		Class<?> wsClass = JAXWSHelper.getWebServiceClass(clazz);
		String serviceName = JAXWSHelper.getWebServiceName(wsClass);
		if (serviceName == null) {
			serviceName = clazz.getSimpleName();
		}
		String targetNamespace = JAXWSHelper.getWebServiceTargetNameSpace(wsClass);
		final QName serviceQName = new QName(targetNamespace, serviceName);
		String address = baseURL;

		final JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
		sf.setDataBinding(new JAXBDataBinding());
		sf.setServiceBean(bean);

		final String wsdlLocation = JAXWSHelper.getWebServiceWsdlLocation(clazz);
		sf.setAddress(address);
		sf.setServiceClass(wsClass);

		return new Server() {
			org.apache.cxf.endpoint.Server server;

			boolean isStopped = true;
			
			
			public void stop() {
				if(server != null) {
					server.stop();
					isStopped = true;
				}
			}

			public void start() {
				server = sf.create();
				isStopped = false;
			}

			@Override
			public QName getServiceQName() {
				return serviceQName;
			}

			@Override
			public String getAddress() {
				if(server != null) {
					return server.getEndpoint().getEndpointInfo().getAddress();
				}
				return null;
			}

			@Override
			public boolean isStopped() {
				return this.isStopped;
			}

            @Override
            public String getWsdlLocation() {
                return wsdlLocation;
            }
		};
	}

}
