/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.esb;

import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class EndpointAddress {
    private String namespace = null;
    private String servicename = null;
    private String endpointname = null;
    private List<QueryParam> params = null;

    public EndpointAddress(QName sn, String en, QueryParam ... params) {
        this(sn.getNamespaceURI(), sn.getLocalPart(), en, params);
    }

    public EndpointAddress(String ns, String sn, String en, QueryParam ... params) {
        this.namespace = ns;
        this.servicename = sn;
        this.endpointname = en;
        this.params = Arrays.asList(params);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServicename() {
        return this.servicename;
    }

    public String getEndpointname() {
        return this.endpointname;
    }

    public Map<String, String> getQueryMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (QueryParam p : this.params) {
            map.put(p.getKey(), p.getValue());
        }
        return map;
    }

    public String getQueryString() {
        String res = "";
        if (this.params != null && !this.params.isEmpty()) {
            for (QueryParam p : this.params) {
                res = p + ", ";
            }
            res = res.substring(0, res.length() - ", ".length());
        }
        return res;
    }

    public String toString() {
        return "EndpointAddress [namespace=" + this.namespace + ", servicename=" + this.servicename + ", endpointname=" + this.endpointname + "]";
    }
}

