package com.ebmwebsourcing.easycommons.research.util.network;

import java.net.ServerSocket;
import java.util.logging.Logger;

public final class NetworkHelper {

	private static final Logger log = Logger.getLogger(NetworkHelper.class.getName()); 

	public static boolean isPortUsed(int port){
		try{
			ServerSocket socket = new ServerSocket(port);
			socket.close();
			return false;
		}catch(java.io.IOException e){
			log.warning(port+" is open. Another process may own it.");
			return true;
		} 
	}
		
	public static boolean oneOfPortsOpen(int... ports){
		for(int i=0 ; i<ports.length ; i++){
			if(NetworkHelper.isPortUsed(ports[i])){
				return true;
			}
		}
		return false;
	}

}
