package com.ebmwebsourcing.easycommons.research.util.io;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;

public class ErrorUtil {



	public static String printStackTrace(Throwable e) {
		String res = "";
		res = "Caused by: " + e.getMessage();
		for(StackTraceElement trace:e.getStackTrace()) {
			res = res + trace.toString() + "\n";
		}
		if(e.getCause() != null) {
			res = res + "\n" + printStackTrace(e.getCause());
		}
		return res;
	}

	public static Document createBusinessOrTechnicalError(Exception e, String methodName) throws SOAException {
		Document res = null;
		try {
			Method m = ReflectionHelper.getPublicMethod(e.getClass(), methodName);
			if(m != null) {
				Object businessFault = m.invoke(e);
				System.out.println("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO businessFault: " + businessFault);
				if(businessFault != null) {
					res = SOAJAXBContext.getInstance().unmarshallAnyElement(businessFault);
				} else {
					System.out.println("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO STACK TRACE:\n" + printStackTrace(e));
					res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(String.valueOf("<error><![CDATA[" + printStackTrace(e) + "]]></error>").getBytes()));
				}
			} else {
				res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(String.valueOf("<error><![CDATA[" + printStackTrace(e) + "]]></error>").getBytes()));
			}
		} catch(Exception ex) {
			throw new SOAException(ex);
		}
		return res;
	}
}
