package com.ebmwebsourcing.easycommons.research.util.esb;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easycommons.research.util.SOAException;

public class ESBUtil {


	private ESBUtil() {

	}


	public static EndpointAddress analyzeURI(URI address) throws SOAException {
		EndpointAddress res = null;

		String addr = address.toString().replace("esb://", "");
		String ns = null;
		String serv = null;
		String ep = null;

		if(!addr.contains("@")) {
			throw new SOAException("Endpoint address not valid: " + address);
		}

		if(addr.contains("::")) {
			ns = addr.substring(0, addr.indexOf("::"));
			serv = addr.substring(addr.indexOf("::") + "::".length(), addr.indexOf("@"));
		} else {
			ns = addr.substring(0, addr.indexOf("@"));
		}
		
		if(serv != null && "null".equals(serv)) {
			serv = null;
		}

		if(addr.indexOf("?") > 0) {
			ep = addr.substring(addr.indexOf("@") + "@".length(), addr.indexOf("?"));
			if(ep.equals("null")) {
				ep = null;
			}
			String query = addr.substring(addr.indexOf("?"));
			List<QueryParam> params = analyseQuery(query);
			res = new EndpointAddress(ns, serv, ep);
		} else {
			ep = addr.substring(addr.indexOf("@") + "@".length(), addr.length());
			if(ep.equals("null")) {
				ep = null;
			}
			res = new EndpointAddress(ns, serv, ep);
		}
		

		return res;
	}

	private static List<QueryParam> analyseQuery(String query) {
		List<QueryParam> params = new ArrayList<QueryParam>();
		for(String param: query.split(",")) {
			String key = param.trim().split("=")[0]; 
			String value = param.trim().split("=")[1];
			params.add(new QueryParam(key, value));
		}
		
		return params;
	}

	public static URI generateURI(EndpointAddress addr) {
		URI res = null;
		String ref = "esb://";

		ref = ref + addr.getNamespace();
		if(addr.getServicename() != null && addr.getServicename().trim().length() > 0) {
			ref = ref + "::" + addr.getServicename();
		}
		ref = ref + "@" + addr.getEndpointname();
		
		if(addr.getQueryString() != null && addr.getQueryString().trim().length() > 0) {
			ref = ref + "?" + addr.getQueryString();
		}
		
		res = URI.create(ref);
		return res;
	}

	public static URI getURIWithoutQuery(URI uri) {
		if(uri.toString().indexOf("?") > 0)  {
			return URI.create(uri.toString().substring(0, uri.toString().indexOf("?")));
		}
		return uri;
	}
	
}
