/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.cxf;

import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.jaxws.JAXWSHelper;
import javax.xml.namespace.QName;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;

public class CXFHelper {
    public static <T> T getClient(String fullURL, Class<T> clazz) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(fullURL);
        factory.setServiceClass(clazz);
        Object client = factory.create();
        return clazz.cast(client);
    }

    public static <T> Server getService(String baseURL, Class<T> clazz, Object bean) {
        Class<?> wsClass = JAXWSHelper.getWebServiceClass(clazz);
        String serviceName = JAXWSHelper.getWebServiceName(wsClass);
        if (serviceName == null) {
            serviceName = clazz.getSimpleName();
        }
        String targetNamespace = JAXWSHelper.getWebServiceTargetNameSpace(wsClass);
        final QName serviceQName = new QName(targetNamespace, serviceName);
        String address = baseURL;
        final JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.setDataBinding((DataBinding)new JAXBDataBinding());
        sf.setServiceBean(bean);
        final String wsdlLocation = JAXWSHelper.getWebServiceWsdlLocation(clazz);
        sf.setAddress(address);
        sf.setServiceClass(wsClass);
        return new Server(){
            org.apache.cxf.endpoint.Server server;
            boolean isStopped = true;

            @Override
            public void stop() {
                if (this.server != null) {
                    this.server.stop();
                    this.isStopped = true;
                }
            }

            @Override
            public void start() {
                this.server = sf.create();
                this.isStopped = false;
            }

            @Override
            public QName getServiceQName() {
                return serviceQName;
            }

            @Override
            public String getAddress() {
                if (this.server != null) {
                    return this.server.getEndpoint().getEndpointInfo().getAddress();
                }
                return null;
            }

            @Override
            public boolean isStopped() {
                return this.isStopped;
            }

            @Override
            public String getWsdlLocation() {
                return wsdlLocation;
            }
        };
    }
}

