/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ExplorerView.java
 *
 * Created on 23 mars 2011, 22:57:38
 */

package com.petalslink.easycommons.explorer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;

/**
 *
 * @author nsalatge
 */
public class ExplorerView extends javax.swing.JPanel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static int SPACE = 20;
	private JScrollPane jScrollPaneView;

	private ComponentG component;
	private List<BindingG> bindings;
	private TextG internalItemNameToPrint = null;

	private Object draggedItem = null;
	private Object resizableItem = null;

	private MenuMouseExplorer mme = null;

	private JFrame parent;

	/** Creates new form ExplorerView 
	 * @throws SCAException */
	public ExplorerView(Dimension dim, Component model, JFrame parent) throws SCAException {
		this.jScrollPaneView = new JScrollPane();
		this.jScrollPaneView.add(this);
		initComponents();

		this.parent = parent;
		mme = new MenuMouseExplorer(this);
		setBackground(Color.white);
		this.setSize(dim);
		this.component = new ComponentG(this, model, null, SPACE, SPACE, (int)this.getWidth() - SPACE*2, (int)this.getHeight()- SPACE*2, true);
		this.component.setTopComponent(true);
		bindings = createBindings();
	}

	public JScrollPane getjScrollPaneView() {
		return jScrollPaneView;
	}

	private List<BindingG> createBindings() {
		List<BindingG> bindings = new ArrayList<BindingG>();
		try {
			// create binds
			for(ComponentG child: this.component.getUnderComponents()) {
				Map<String, Interface> binds = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(child.getModel());
				for(Entry<String, Interface> entry: binds.entrySet()) {
					if(entry.getValue() != null) {
						ReferenceG ref = child.findReference(entry.getKey());
						ServiceG serv = this.component.findService(SCAHelper.getSCAHelper().getName(entry.getValue().getFcItfOwner()), entry.getValue().getFcItfOwner().getFcInterface(entry.getValue().getFcItfName()).getClass().getInterfaces()[0]);
						bindings.add(new BindingG(ref, serv));
					}
				}
			}
		} catch (NoSuchInterfaceException e) {
			e.printStackTrace();
			// do nothing
		} catch (SCAException e) {
			e.printStackTrace();
			// do nothing
		}
		return bindings;
	}

	@Override
	public void paint(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setPaint(Color.white);

		g2.drawRect(0, 0, (int) this.getWidth(), (int) this.getHeight());
		g2.fillRect(0, 0, (int) this.getWidth(), (int) this.getHeight());

		if(resizableItem != this.component) {
			this.component.getRectangle().x = SPACE;
			this.component.getRectangle().y = SPACE;
			this.component.getRectangle().width = this.getWidth() - SPACE*2;
			this.component.getRectangle().height = this.getHeight() - SPACE*2;
		}
		this.component.update(g);

		if(this.mme.getjMenuItemPrintBindings().isSelected()) {
			for(BindingG b: this.bindings) {
				b.update(g2);
			}
		}


		if(this.internalItemNameToPrint != null) {
			g.setColor(this.internalItemNameToPrint.getColor());
			g.drawString(this.internalItemNameToPrint.getText(), (int)this.internalItemNameToPrint.getX(), (int)this.internalItemNameToPrint.getY());
		}

		g.dispose();
	}
	
	public MenuMouseExplorer getMme() {
		return mme;
	}

	public ComponentG getComponent() {
		return component;
	}

	public static Object getObjectContainedIn(ComponentG parent, java.awt.event.MouseEvent evt) {

		for(ServiceG service: parent.getServices()) {
			if(service.contains(evt.getX(), evt.getY())) {
				return service;
			}
		}

		for(ReferenceG reference: parent.getReferences()) {
			if(reference.contains(evt.getX(), evt.getY())) {
				return reference;
			}
		}

		for(ControllerG controller: parent.getControllers()) {
			if(controller.contains(evt.getX(), evt.getY())) {
				return controller;
			}
		}

		if(parent.getCorner().contains(evt.getX(), evt.getY())) {
			return parent.getCorner();
		}

		for(ComponentG child: parent.getUnderComponents()) {
			Object item = getObjectContainedIn(child, evt);
			if(item == null) {
				if(child.contains(evt.getX(), evt.getY())) {
					return child;
				}
			} else if(item instanceof ComponentG) {
				return child;
			} else {
				return item;
			}
		}

		return null;
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				formMouseClicked(evt);
			}
			public void mousePressed(java.awt.event.MouseEvent evt) {
				formMousePressed(evt);
			}
			public void mouseReleased(java.awt.event.MouseEvent evt) {
				formMouseReleased(evt);
			}
		});
		addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
			public void mouseDragged(java.awt.event.MouseEvent evt) {
				formMouseDragged(evt);
			}
			public void mouseMoved(java.awt.event.MouseEvent evt) {
				formMouseMoved(evt);
			}
		});

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
		this.setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 769, Short.MAX_VALUE)
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 603, Short.MAX_VALUE)
		);
	}// </editor-fold>//GEN-END:initComponents

	private void formMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMousePressed


		draggedItem = null;
		resizableItem = null;
		Object selectedItem = getObjectContainedIn(this.component, evt);
		if(selectedItem instanceof CornerG) {
			CornerG corner = (CornerG) selectedItem;
			if(corner.contains(evt.getX(), evt.getY())) {
				resizableItem = corner.getParent();
				corner.getParent().setResizable(true);
			} 
		} else if(selectedItem instanceof ComponentG){
			ComponentG component = (ComponentG) selectedItem;
			if (component.contains(evt.getX(), evt.getY())) {
				draggedItem = component;
				// get on top
				if(this.component.getUnderComponents().contains(component)) {
					this.component.getUnderComponents().remove(component);
					this.component.getUnderComponents().add(component);
				}
				component.setMove(true);
			} 
		}
	}//GEN-LAST:event_formMousePressed

	private void formMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseClicked
		try {
			this.repaint();
			Object selectedItem = getObjectContainedIn(this.component, evt);
			if(evt.getButton() == MouseEvent.BUTTON1 && evt.getClickCount() == 2) {
				if(selectedItem instanceof ComponentG) {
					setComponent((ComponentG)selectedItem);
				}
			}

			mme.setVisible(false);
			if(evt.getButton() == MouseEvent.BUTTON3) {
				if(this.parent instanceof ExplorerFrame) {
					ExplorerFrame explorerFrame = (ExplorerFrame)this.parent;
					mme.setLocation(evt.getX() + explorerFrame.getX() + explorerFrame.getjTree().getWidth() - (mme.getWidth()/2), evt.getY() + explorerFrame.getY() + 70);
				}
				mme.setVisible(true);
			}
		} catch (SCAException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Explorer component Interrupted", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_formMouseClicked

	public void setComponent(ComponentG selectedItem) throws SCAException {
		this.component.setTopComponent(false);
		if(this.component.getParent() != null) {
			this.component.setDepth(false);
		}
		this.component = ((ComponentG)selectedItem);
		this.component.getRectangle().x = SPACE;
		this.component.getRectangle().y = SPACE;
		this.component.getRectangle().width = this.getWidth() - SPACE*2;
		this.component.getRectangle().height = this.getHeight() - SPACE*2;
		//		this.component.setLocation(SPACE, SPACE);
		//		this.component.setSize(this.getWidth() - SPACE*2, this.getHeight() - SPACE*2);
		this.component.setTopComponent(true);
		this.component.init();
		this.component.setDepth(true);

		this.bindings = this.createBindings();

		this.repaint();
	}
	
	public static Dimension getTextSize(Graphics2D g2, String text) {
		// get metrics from the graphics
		FontMetrics metrics = g2.getFontMetrics();
		// get the height of a line of text in this font and render context
		int hgt = metrics.getHeight();
		// get the advance of my text in this font and render context
		int adv = metrics.stringWidth(text);
		// calculate the size of a box to hold the text with some padding.
		Dimension textSize = new Dimension(adv+2, hgt+2);

		return textSize;
	}

	private void formMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseDragged
		if(draggedItem != null && draggedItem instanceof ComponentG) {
			((ComponentG)draggedItem).setLocation(evt.getX(), evt.getY());
		} else if(resizableItem != null && resizableItem instanceof ComponentG) {
			((ComponentG)resizableItem).resize(evt.getX(), evt.getY());
		}
		this.repaint();
	}//GEN-LAST:event_formMouseDragged

	private void formMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseMoved
		Object selectedItem = getObjectContainedIn(this.component, evt);
		if(selectedItem instanceof ServiceG) {
			ServiceG s = (ServiceG) selectedItem;
			this.internalItemNameToPrint = new TextG(s.getName(), Color.black, (int)s.getRectangle().x, (int)s.getRectangle().y + s.getRectangle().height);
		} else if(selectedItem instanceof ControllerG) {
			ControllerG c = (ControllerG) selectedItem;
			this.internalItemNameToPrint = new TextG(c.getName(), Color.black, (int)c.getRectangle().x, (int)c.getRectangle().y - c.getRectangle().height);
		} else if(selectedItem instanceof ReferenceG) {
			ReferenceG r = (ReferenceG) selectedItem;
			this.internalItemNameToPrint = new TextG(r.getName(), Color.black, (int)r.getRectangle().x - ExplorerView.getTextSize((Graphics2D) this.getGraphics(), r.getName()).width, (int)r.getRectangle().y + r.getRectangle().height);
		} else {
			this.internalItemNameToPrint = null;
		}
		this.repaint();
	}//GEN-LAST:event_formMouseMoved

	private void formMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseReleased
		if(draggedItem instanceof ComponentG) {
			((ComponentG)draggedItem).setMove(false);
		}
		if(resizableItem instanceof ComponentG) {
			((ComponentG)resizableItem).setResizable(false);
		}
		draggedItem = null;
		resizableItem = null;
	}//GEN-LAST:event_formMouseReleased


	// Variables declaration - do not modify//GEN-BEGIN:variables
	// End of variables declaration//GEN-END:variables

}
