/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.petalslink.easycommons.explorer;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;



/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class TreeComponentCellRenderer extends DefaultTreeCellRenderer {

	private static final ImageIcon emptyComponentIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/empty-composite.png"));
	private static final ImageIcon compositeIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/composite.png"));
	private static final ImageIcon primitifIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/primitive.png"));
	private static final ImageIcon serviceIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/service.png"));
	private static final ImageIcon referenceIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/reference.png"));
	private static final ImageIcon controllerIcon = createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/explorer/controller.png"));


	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/** Creates a new instance of DevisDirectoryTreeCellRenderer */
	public TreeComponentCellRenderer() {
	}

	@Override
	public Component getTreeCellRendererComponent(final JTree tree,
			final Object value, final boolean selected, final boolean expanded,
			final boolean leaf, final int row, final boolean hasFocus) {
		try {
			super.getTreeCellRendererComponent(tree, value, selected, expanded,
					leaf, row, hasFocus);

			if(value instanceof ComponentG){
				ComponentG comp = (ComponentG)value;
				if(comp.getUnderComponents().size() == 0) {
					this.setIcon(primitifIcon);
					this.setToolTipText("This is a primitive component.");
				} else {
					this.setIcon(compositeIcon);
					this.setToolTipText("This is a composite component.");
				}
				if(SCAHelper.getSCAHelper().isStarted(comp.getModel())) {
					this.setForeground(Color.blue);
				} else {
					this.setForeground(Color.red);
				}
			} else if(value instanceof TreeComponentModel.Components){
				this.setText(value.toString());
				this.setIcon(emptyComponentIcon);
				this.setToolTipText("This is the list of child components.");
			} else if(value instanceof TreeComponentModel.Services){
				this.setText(value.toString());
				this.setIcon(serviceIcon);
				this.setToolTipText("This is the list of child services.");
			} else if(value instanceof TreeComponentModel.References){
				this.setText(value.toString());
				this.setIcon(referenceIcon);
				this.setToolTipText("This is the list of child references.");
			} else if(value instanceof TreeComponentModel.Controllers){
				this.setText(value.toString());
				this.setIcon(controllerIcon);
				this.setToolTipText("This is the list of child controllers.");
			} else if(value instanceof ServiceG){
				this.setText(((ServiceG) value).getName());
				this.setIcon(serviceIcon);
				this.setToolTipText("This is a service.");
			} else if(value instanceof ReferenceG){
				this.setText(((ReferenceG) value).getName());
				this.setIcon(referenceIcon);
				this.setToolTipText("This is a reference.");
			} else if(value instanceof ControllerG) {
				this.setText(((ControllerG)value).getName());
				this.setIcon(controllerIcon);
				this.setToolTipText("This is a controller.");
			} else {
				this.setText(value.toString());
			}
		} catch (SCAException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Explorer component Interrupted", JOptionPane.ERROR_MESSAGE);
		}
		return this;
	}


	/** Returns an ImageIcon, or null if the path was invalid. */
	private static ImageIcon createImageIcon(URL imgURL) {
		ImageIcon img = new ImageIcon(imgURL);
		return img;
	}

}
